#include <bits/stdc++.h>
using namespace std;
#define INF 0x3f3f3f3f


typedef pair<int, int> iPair;


class Graph {
    int V;
    list<pair<int, int> >* adj;

public:
    Graph(int V);


    void addEdge(int u, int v, int w);


    void shortestPath(int s, int c);
};


Graph::Graph(int V)
{
    this->V = V;
    adj = new list<iPair>[V];
}

void Graph::addEdge(int u, int v, int w)
{
    adj[u].push_back(make_pair(v, w));
    adj[v].push_back(make_pair(u, w));
}


void Graph::shortestPath(int src, int c)
{

    priority_queue<iPair, vector<iPair>, greater<iPair> >
        pq;


    vector<int> dist(V, INF);
    vector<int> stanje(V, 0);


    pq.push(make_pair(0, src));
    dist[src] = 0;
    stanje[src] = 0;


    while (!pq.empty()) {

        int u = pq.top().second;
        pq.pop();


        list<pair<int, int> >::iterator i;
        for (i = adj[u].begin(); i != adj[u].end(); ++i) {

            int v = (*i).first;
            int weight = (*i).second;
            int p = 0;
            if ((stanje[u] == 0 && weight == 1) || (stanje[u] == 1 && weight == 0))
                p = 1;


            if (dist[v] > dist[u] + p) {

                dist[v] = dist[u] + p;
                if (p == 0)
                    stanje[v] = stanje[u];
                else if (stanje[u] == 0)
                    stanje[v] = 1;
                else
                    stanje[v] = 0;
                pq.push(make_pair(dist[v], v));
            }
        }
    }
    cout << dist[c];


}


int main()
{
    int N, M;
    cin >> N >> M;
    Graph g(N);
    for (int i = 0; i < M; i++)
    {
        int a, b, t;
        cin >> a >> b >> t;
        a--;
        b--;
        g.addEdge(a,b,t);
    }
    int u, v;
    cin >> u >> v;
    u--;
    v--;
    g.shortestPath(u, v);
}