#include <iostream>
#include <vector>

using namespace std;

struct put 
{
    int cvor1, cvor2;
    bool led;
};

int Dijkstra(int pocetak, int kraj, vector<put> graf, int brSanti) 
{
    int** matrica = new int* [brSanti];
    for (int i = 0;i < brSanti;i++) 
    {
        matrica[i] = new int[brSanti];
        for (int j = 0; j < brSanti;j++) 
        {
            matrica[i][j] = (i == j) ? 0 : -1;
        }
    }
    for (int i = 0; i < graf.size();i++) 
    {
        matrica[graf[i].cvor1-1][graf[i].cvor2-1] = (int)graf[i].led;
        matrica[graf[i].cvor2-1][graf[i].cvor1-1] = (int)graf[i].led;
    }
    bool trenutnoStanje = 0;
    int* brPaljenjaIGasenja = new int[brSanti];
    bool* posecen = new bool[brSanti];
    int* dosaoIz = new int[brSanti];
    for (int i = 0; i < brSanti;i++) 
    {
        brPaljenjaIGasenja[i] = INT_MAX;
        posecen[i] = false;
        dosaoIz[i] = -1;
    }
    int brPosecenih = 1;
    int trenutni = pocetak-1;
    brPaljenjaIGasenja[trenutni] = 0;
    posecen[trenutni] = true;
    dosaoIz[trenutni] = trenutni;
    while (brPosecenih < brSanti) 
    {
        for (int i = 0; i < brSanti; i++) 
        {
            if (!posecen[i] && matrica[i][trenutni] != -1 && brPaljenjaIGasenja[i] > brPaljenjaIGasenja[trenutni] + abs(matrica[i][trenutni]-(int)trenutnoStanje)) 
            {
                brPaljenjaIGasenja[i] = brPaljenjaIGasenja[trenutni] + abs(matrica[i][trenutni]-(int) trenutnoStanje);
                dosaoIz[i] = trenutni;
            }
        }
        int min = INT_MAX;
        for (int i = 0; i < brSanti; i++) 
        {
            if (!posecen[i] && min > brPaljenjaIGasenja[i]) 
            {
                min = brPaljenjaIGasenja[i];
                trenutni = i;
            }
        }
        trenutnoStanje = matrica[dosaoIz[trenutni]][trenutni];
        posecen[trenutni] = true;
        brPosecenih++;
    }
    int resenje = brPaljenjaIGasenja[kraj-1];
    delete[]brPaljenjaIGasenja;
    for (int i = 0; i < brSanti;i++) 
    {
        delete[] matrica[i];
    }
    delete[] matrica;
    delete[] posecen;
    delete[] dosaoIz;
    if (resenje == INT_MAX) return -1;
    return resenje;
}

int main()
{
    put tmp;
    vector<put> graf;
    int brSanti, brPuteva;
    cin >> brSanti >> brPuteva;
    for (int i = 0; i < brPuteva;i++) 
    {
        cin >> tmp.cvor1 >> tmp.cvor2 >> tmp.led;
        graf.push_back(tmp);
    }
    int pocetak, kraj;
    cin >> pocetak >> kraj;
    cout << Dijkstra(pocetak, kraj, graf, brSanti);
}