#include <iostream>
#include <limits>
using namespace std;

class mat
{
private:
	int** m_arr;
	int m_size;
public:
	mat(int size) : m_size(size)
	{
		m_arr = new int * [m_size];
		for (int i = 0; i < m_size; i++) m_arr[i] = new int[m_size];
	}

	mat(int size, int fill) : m_size(size)
	{
		m_arr = new int * [m_size];
		for (int i = 0; i < m_size; i++) m_arr[i] = new int[m_size];
		this->fill(fill);
	}

	void fill(int value)
	{
		for (int i = 0; i < m_size; i++)
		{
			for (int j = 0; j < m_size; j++)
			{
				m_arr[i][j] = value;
			}
		}
	}

	int*& operator[](int i) { return m_arr[i]; }

	int length() { return m_size; }
};

int*& dijkstra(mat matrica, int pocetak)
{
	int br_cvorova = matrica.length();

	int* res = new int[br_cvorova];
	int MAX = numeric_limits<int>::max();
	bool* poseceni = new bool[br_cvorova];

	for (int i = 0; i < br_cvorova; i++)
	{
		res[i] = i == pocetak ? 0 : MAX;
		poseceni[i] = false;
	}

	int pointer = pocetak, tr_duzina = 0, posecenih = 0;
	bool prethodno_stanje = false;

	while (posecenih < br_cvorova - 1)
	{
		poseceni[pointer] = true;
		posecenih++;
		for (int i = 0; i < br_cvorova; i++)
		{
			if (poseceni[i] || i == pointer || matrica[pointer][i] == -1) continue;
			if (tr_duzina + abs(tr_duzina % 2 - matrica[pointer][i]) < res[i])
			{
				res[i] = tr_duzina + abs(tr_duzina % 2 - matrica[pointer][i]);
			}
		}

		int sl_pointer = -1;
		for (int i = 0; i < br_cvorova; i++)
		{
			if (poseceni[i] || res[i] == MAX) continue;
			if (sl_pointer == -1) sl_pointer = i;
			else if (res[i] < res[sl_pointer]) sl_pointer = i;
		}

		if (sl_pointer == -1)
		{
			for (int i = 0; i < br_cvorova; i++) if (res[i] == MAX) res[i] = -1;
			return res;
		}

		pointer = sl_pointer;
		tr_duzina = res[sl_pointer];
	}
	return res;
}

int main()
{
	int n, g;
	cin >> n >> g;
	mat test(n, -1);
	for (int i = 0; i < n; i++) test[i][i] = 0;

	int c1, c2, t;
	for (int i = 0; i < g; i++)
	{
		cin >> c1 >> c2 >> t;
		test[c1-1][c2-1] = t;
		test[c2-1][c1-1] = t;
	}

	int mika, laza;
	cin >> mika >> laza;

	int* res = dijkstra(test, mika-1);
	cout << res[laza - 1];
	delete[] res;
}