#include <bits/stdc++.h>
using namespace std;
#define INF 0x3f3f3f3f
typedef pair<int, int> iPair;

class Graph
{
    int V;

    list<pair<int, int> >* adj;

public:
    Graph(int V);

    void addEdge(int u, int v, int w);

    void shortestPath(int s, int e);
};

Graph::Graph(int V)
{
    this->V = V;
    adj = new list<iPair>[V];
}

void Graph::addEdge(int u, int v, int w)
{
    adj[u].push_back(make_pair(v, w));
    adj[v].push_back(make_pair(u, w));
}

void Graph::shortestPath(int src, int last)
{
    priority_queue<iPair, vector<iPair>, greater<iPair> > pq;

    vector<int> dist(V, INF);

    pq.push(make_pair(0, src));
    dist[src] = 0;

    while (!pq.empty())
    {
        int u = pq.top().second;
        pq.pop();

        list<pair<int, int> >::iterator i;
        for (i = adj[u].begin(); i != adj[u].end(); i++)
        {
            int v = (*i).first;

            int weight = (*i).second;

            if (dist[v] > dist[u] + weight)
            {
                if(v == last && weight == 2)
                    dist[v] = dist[u] + weight - 1;
                else
                    dist[v] = dist[u] + weight;
                pq.push(make_pair(dist[v], v));
            }
        }
    }
    if(dist[last] != INF)
        cout << dist[last];
    else cout << -1;
}

int main()
{
    int v, e;
    cin >> v >> e;
    Graph g(v);

    for(int i = 0; i < e; i++)
    {
        int v1, v2, w;
        cin >> v1 >> v2 >> w;
        v1--;
        v2--;
        if(w == 1) w++;
        g.addEdge(v1, v2, w);
    }
    int startPoint, endPoint;
    cin >> startPoint >> endPoint;
    startPoint--;
    endPoint--;
    g.shortestPath(startPoint, endPoint);

    return 0;
}