#include <iostream>
#include <vector>
#include <queue>
#include <map>
#include <algorithm>
#include <limits.h>
using namespace std;

vector<vector<int>> imaLed;
int najmanjiBroj = INT_MAX;

bool search(vector<int> arr, int x)
{
    for(int i = 0; i < arr.size(); i++)
        if(arr[i] == x)
            return true;
    return false;
}

void proveriNajmanjiBroj(vector<int>& path)
{
    int radiMasina = 0;
    int size = path.size();
    int brojMenjanja = 0;

    for(int i = 1; i < path.size(); i++)
    {
        if(search(imaLed[path[i-1]], path[i]))
        {
            if(radiMasina == 0)
            {
                radiMasina = 1;
                brojMenjanja += 1;
            }
        }
        else
        {
            if(radiMasina == 1)
            {
                radiMasina = 0;
                brojMenjanja += 1;
            }
        }
    }

    if(brojMenjanja < najmanjiBroj)
        najmanjiBroj = brojMenjanja;

    cout << najmanjiBroj;
}
 
int isNotVisited(int x, vector<int>& path)
{
    int size = path.size();
    for (int i = 0; i < size; i++)
        if (path[i] == x)
            return 0;
    return 1;
}

void findpaths(vector<vector<int> >& g, int src, int dst, int v)
{
    queue<vector<int> > q;

    vector<int> path;
    path.push_back(src);
    q.push(path);
    while (!q.empty()) {
        path = q.front();
        q.pop();
        int last = path[path.size() - 1];

        if (last == dst)
            proveriNajmanjiBroj(path);
 
        for (int i = 0; i < g[last].size(); i++) {
            if (isNotVisited(g[last][i], path)) {
                vector<int> newpath(path);
                newpath.push_back(g[last][i]);
                q.push(newpath);
            }
        }
    }
}
 
// driver program
int main()
{
    vector<vector<int>> putanje;
    int brojTacaka;
    cin >> brojTacaka;
    imaLed.resize(brojTacaka);
    putanje.resize(brojTacaka);
 
    int brojPutanja;
    cin >> brojPutanja;

    for(int i = 0; i < brojPutanja; i++)
    {
        int pocetak, kraj, tacnost;

        cin >> pocetak >> kraj >> tacnost;

        putanje[pocetak].push_back(kraj);
        if(tacnost == 1)
            imaLed[pocetak].insert(upper_bound(imaLed[pocetak].begin(), imaLed[pocetak].end(), kraj), kraj);
    }

    int src, dst;
    cin >> src >> dst;

    findpaths(putanje, src, dst, brojTacaka);
 
    return 0;
}