#include <iostream>
#include "vector"
#include "algorithm"
#include "numeric"
#include "climits"
#include "iomanip"
#include "bitset"
#include "cmath"
#include "map"
#include "deque"
#include "array"
#include "set"
#define all(x) x.begin(), x.end()
using namespace std;
struct mergesorttree {
    int sz;
    vector<vector<int>> tree;
    void init(vector<int> a) {
        sz = 1;
        while (sz < a.size())
            sz *= 2;
        tree.assign(sz * 2, {});
        for (int i = 0; i < a.size(); ++i) {
            tree[i + sz] = {a[i]};
        }
        for (int i = sz - 1; i > 0; --i) {
            merge(all(tree[i * 2]), all(tree[i * 2 + 1]), back_inserter(tree[i]));
        }
    }
    int getless(int l, int r, int x) {
        l += sz;r += sz;
        int res = 0;
        while (l <= r) {
            if (l % 2 == 1) {
                res += lower_bound(all(tree[l]), x) - tree[l].begin();
                l++;
            }
            if (r % 2 == 0) {
                res += lower_bound(all(tree[r]), x) - tree[r].begin();
                r--;
            }
            l /= 2;
            r /= 2;
        }
        return res;
    }
};
signed main() {
    ios::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);
    int n, m;
    cin >> n >> m;
    vector<int> a(n), b(n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i] >> b[i];
        a[i]--;
    }
    mergesorttree sg1, sg2;
    sg1.init(a);
    sg2.init(b);
    for (int i = 0; i < m; ++i) {
        int l, r, x;
        cin >> l >> r >> x;
        l--;r--;
        cout << sg1.getless(l, r, x) - sg2.getless(l, r, x) << '\n';
    }
}