#include <iostream>
#include <unordered_map>
#include <cmath>
#include <vector>
#include <map>
#include <algorithm>
#include <string>
#include <queue>

struct node {
    int center;
    node* left, * right;
    std::vector<std::vector<int>> sorted1, sorted2;
};

node* init(int center, std::vector<std::vector<int>> intervals) {
    node* temp = new node;
    temp->left = NULL;
    temp->right = NULL;
    temp->center = center;
    temp->sorted1 = intervals;
    std::sort(intervals.begin(), intervals.end(), [] (auto& a, auto& b) { return a[1] < b[1]; });
    temp->sorted2 = intervals;
    return temp;
};

node* construct(node* root, std::vector<std::vector<int>> indices) {
    if (indices.size() < 1) {
        return NULL;
    }
    else if (indices.size() == 1) {
        return init((indices[0][0]+indices[0][1])/2, indices);
    }
    std::vector<std::vector<int>> left, right, center;
    int min = INT_MAX, max = INT_MIN;
    for (int i = 0; i < indices.size(); i++) {
        if (indices[i][0] < min) {
            min = indices[i][0];
        }
        if (indices[i][1] > max) {
            max = indices[i][1];
        }
    }
    int pivot = (max + min) / 2;
    for (int i = 0; i < indices.size(); i++) {
        if (indices[i][1] < pivot) {
            left.push_back(indices[i]);
        }
        else if (indices[i][0] > pivot) {
            right.push_back(indices[i]);
        }
        else {
            center.push_back(indices[i]);
        }
    }
    root = init(pivot, center);
    root->left = construct(root->left, left);
    root->right = construct(root->right, right);
    return root;
}

int res = 0;

void traverse(node* root, int vstart, int vend, int target) {
    if (root == NULL) {
        return;
    }

    if (target <= root->center) {
        //find closest start to target

        int ins = 0;
        std::vector<std::vector<int>> intervals = root->sorted1;
        for (int i = 0; i < intervals.size(); i++) {
            if (intervals[i][0] <= target && intervals[i][2] >= vstart && intervals[i][2] <= vend) {
                res++;
            }
            else if (intervals[i][0] > target) break;
        }
    }
    else if (target > root->center) {
        //find closest end to target

        int ins = 0;
        std::vector<std::vector<int>> intervals = root->sorted2;
        for (int i = intervals.size()-1; i >= 0; i--) {
            if (intervals[i][1] >= target && intervals[i][2] >= vstart && intervals[i][2] <= vend) {
                res++;
            }
            else if (intervals[i][1] < target) {
                break;
            }
        }
    }

    if (target < root->center) {
        traverse(root->left, vstart, vend, target);
    }
    else if (target > root->center) {
        traverse(root->right, vstart, vend, target);
    }
}

int main() {
    //IST

    std::ios_base::sync_with_stdio(false); std::cin.tie(0);

    int n, q;
    std::cin >> n >> q;
    std::vector<std::vector<int>> indices;
    for (int i = 0; i < n; i++) {
        int a, b;
        std::cin >> a >> b;
        indices.push_back({ a, b, i + 1 });
    }
    std::sort(indices.begin(), indices.end());

    node* root = NULL;
    root = construct(root, indices);

    for (int i = 0; i < q; i++) {
        res = 0;
        int a, b, c;
        std::cin >> a >> b >> c;
        traverse(root, a, b, c);
        std::cout << res << std::endl;
    }
}