/* https://judge.yosupo.jp/submission/74301 */
#include <vector>
#include <array>
#include <algorithm>
#include <iostream>

/*
struct point_add_rectangle_sum{
  struct point{int x, y, z;};
  struct query{int lx, rx, ly, ry;};
  using ll = long long;

  struct binary_indexed_tree{
    int N;
    std::vector<ll> sum;
    binary_indexed_tree(int N): N(N), sum(N + 1, 0){}
    void add(int k, ll x){
      for(int i = k + 1; i <= N; i += (i & (-i))) sum[i] += x;
    }
    ll getsum(int r){
      ll ret = 0;
      for(int k = r; k > 0; k -= (k & (-k))) ret += sum[k];
      return ret;
    }
    ll getsum(int l, int r){
      return getsum(r) - getsum(l);
    }
  };
  std::vector<ll> static_rectangle_sum(std::vector<point> &P, const std::vector<query> &Q){
    struct event{int x, ly, ry, id;};
    int N = Q.size();
    if(P.empty() || Q.empty()) return std::vector<ll>(N, 0);
    std::vector<event> Q2(2 * N);
    std::vector<ll> ans(N, 0);
    std::vector<int> Y;
    std::sort(P.begin(), P.end(), [](const point &a, const point &b){return a.y < b.y;});
    for(point &t : P){
      if(Y.empty() || Y.back() != t.y){
        Y.push_back(t.y);
        t.y = int(Y.size()) - 1;
      }
    }
    for(int i = 0; i < N; i++){
      int ly = std::lower_bound(Y.begin(), Y.end(), Q[i].ly) - Y.begin();
      int ry = std::lower_bound(Y.begin(), Y.end(), Q[i].ry) - Y.begin();
      Q2[2 * i] = event{Q[i].lx, ly, ry, i};
      Q2[2 * i + 1] = event{Q[i].rx, ly, ry, i + N};
    }
    std::sort(P.begin(), P.end(), [](const point &a, const point &b){return a.x < b.x;});
    std::sort(Q2.begin(), Q2.end(), [](const event &a, const event &b){return a.x < b.x;});
    binary_indexed_tree bit(Y.size());
    int p = 0, q = 0;
    while(q < 2 * N){
      if(p == P.size() || Q2[q].x <= P[p].x){
        ll sum = bit.getsum(Q2[q].ly, Q2[q].ry);
        if(Q2[q].id >= N) ans[Q2[q].id - N] += sum;
        else ans[Q2[q].id] -= sum;
        q++;
      }else{
        bit.add(P[p].y, P[p].z);
        p++;
      }
    }
    return ans;
  }

};
*/

struct point{int x, y, z;};
struct query{int lx, rx, ly, ry;};
using ll = long long;
struct binary_indexed_tree{
  int N;
  std::vector<ll> sum;
  binary_indexed_tree(int N): N(N), sum(N + 1, 0){}
  void add(int k, ll x){
    for(int i = k + 1; i <= N; i += (i & (-i))) sum[i] += x;
  }
  ll getsum(int r){
    ll ret = 0;
    for(int k = r; k > 0; k -= (k & (-k))) ret += sum[k];
    return ret;
  }
  ll getsum(int l, int r){
    return getsum(r) - getsum(l);
  }
};
std::vector<ll> static_rectangle_sum(std::vector<point> &P, const std::vector<query> &Q){
  struct event{int x, ly, ry, id;};
  int N = Q.size();
  if(P.empty() || Q.empty()) return std::vector<ll>(N, 0);
  std::vector<event> Q2(2 * N);
  std::vector<ll> ans(N, 0);
  std::vector<int> Y;
  std::sort(P.begin(), P.end(), [](const point &a, const point &b){return a.y < b.y;});
  for(point &t : P){
    if(Y.empty() || Y.back() != t.y) Y.push_back(t.y);
    t.y = int(Y.size()) - 1;
  }
  for(int i = 0; i < N; i++){
    int ly = std::lower_bound(Y.begin(), Y.end(), Q[i].ly) - Y.begin();
    int ry = std::lower_bound(Y.begin(), Y.end(), Q[i].ry) - Y.begin();
    Q2[2 * i] = event{Q[i].lx, ly, ry, i};
    Q2[2 * i + 1] = event{Q[i].rx, ly, ry, i + N};
  }
  std::sort(P.begin(), P.end(), [](const point &a, const point &b){return a.x < b.x;});
  std::sort(Q2.begin(), Q2.end(), [](const event &a, const event &b){return a.x < b.x;});
  binary_indexed_tree bit(Y.size());
  int p = 0, q = 0;
  while(q < 2 * N){
    if(p == P.size() || Q2[q].x <= P[p].x){
      ll sum = bit.getsum(Q2[q].ly, Q2[q].ry);
      if(Q2[q].id >= N) ans[Q2[q].id - N] += sum;
      else ans[Q2[q].id] -= sum;
      q++;
    }else{
      bit.add(P[p].y, P[p].z);
      p++;
    }
  }
  return ans;
}
int main(){
  std::cin.tie(nullptr);
  std::ios::sync_with_stdio(false);
  int n, q;
  std::cin >> n >> q;
  std::vector<point> P(2 * n);
  for(int i = 0; i < n; i++){
    int a, b;
    std::cin >> a >> b;
    P[2 * i] = {i, a, +1};
    P[2 * i + 1] = {i, b + 1, -1};
  }
  std::vector<query> Q(q);
  for(int i = 0; i < q; i++){
    //int a, b, c, d;
    //std::cin >> a >> b >> c >> d;
    int l, r, x;
    std::cin >> l >> r >> x;
    --l;
    Q[i] = {l, r, 0, x + 1};
  }
  auto ans = static_rectangle_sum(P, Q);
  for(ll a: ans) std::cout << a << '\n';
}