using System;
using System.Collections.Generic;
using System.Linq;


namespace ConsoleApp1
{
    internal class Program
    {
        public class Santa
        {
            public int broj
            {
                get; set;
            }
            public List<Santa> putevi
            {
                get; set;
            }
            public Dictionary<int, bool> Led
            {
                get; set;
            }
        }
        public static int OptimalanPut(Santa tren, bool upaljena, Santa cilj)
        {
            List<int> kombinacije = new List<int>();
            int a;
            if(tren == cilj)
            {
                return 0;
            }
            foreach(Santa e in tren.putevi)
            {
                if(upaljena == tren.Led[e.broj])
                {
                    a = OptimalanPut(e, upaljena, cilj);
                }
                else
                {
                    a =  1 + OptimalanPut(e, !upaljena, cilj);
                }
                if(a >= 0)
                {
                    kombinacije.Add(a);
                }
            }
            return kombinacije.Count > 0 ? kombinacije.Min() : -2;
        }
        public static void Main(string[] args)
        {
            List<Santa> list = new List<Santa>();
            string[] red = Console.ReadLine().Split();
            int n = Convert.ToInt32(red[0]);
            int m = Convert.ToInt32(red[1]);
            for (int i = 0; i < n; i++)
            {
                Santa santa = new Santa();
                santa.putevi = new List<Santa>();
                santa.Led = new Dictionary<int, bool>();
                santa.broj = i;
                list.Add(santa);
            }
            for (int i = 0; i < m; i++)
            {
                red = Console.ReadLine().Split();
                Santa santa = list[Convert.ToInt32(red[1]) - 1];
                bool led = Convert.ToInt32(red[2]) == 1 ? true : false;
                list[Convert.ToInt32(red[0])-1].putevi.Add(santa);
                list[Convert.ToInt32(red[0])-1].Led.Add(santa.broj, led);
            }
            red = Console.ReadLine().Split();
            int prva = Convert.ToInt32(red[0]) - 1;
            int poslednja = Convert.ToInt32(red[1]) - 1;
            int ans = OptimalanPut(list[prva], false, list[poslednja]);
            Console.WriteLine(ans == -2 ? -1 : ans);
            Console.ReadLine();
        }
    }
}