#include <iostream>
#include <vector>
#include <string>
#include <list>
#include <map>
#include <set>
#include <math.h>
using namespace std;

struct Put {
	int PocTacka;
	int KrajTacka;
	int Paljenje;
};

vector<bool> Sante;
vector<Put> Putevi;
int total;

class Graph {
	int numVertices;
	list<int>* adjLists;
	bool* visited;

public:
	Graph(int vertices);
	void addEdge(int src, int dest);
	void BFS(int startVertex);
};

Graph::Graph(int vertices) {
	numVertices = vertices;
	adjLists = new list<int>[vertices];
}

void Graph::addEdge(int src, int dest) {
	adjLists[src].push_back(dest);
	adjLists[dest].push_back(src);
}

void Graph::BFS(int startVertex) {
	visited = new bool[numVertices];
	for (int i = 0; i < numVertices; i++)
		visited[i] = false;

	list<int> queue;

	visited[startVertex] = true;
	queue.push_back(startVertex);
	bool MASINA = false;
	list<int>::iterator i;

	while (!queue.empty()) {
		int currVertex = queue.front();
		queue.pop_front();
		for (i = adjLists[currVertex].begin(); i != adjLists[currVertex].end(); ++i) {
			int adjVertex = *i;
			if ((Sante[currVertex - 1] && !MASINA) || (!Sante[currVertex - 1] && MASINA)) {
				total++;
				MASINA = !MASINA;
			}
			if (!visited[adjVertex]) {
				visited[adjVertex] = true;
				queue.push_back(adjVertex);
			}
		}
	}
}

void SetujSante(vector<bool>& Vec, int& Brojac, int Max)
{
	if (Brojac == Max) return;
	Vec.push_back(false);
	SetujSante(Vec, ++Brojac, Max);
}

void UzmiInput(vector<Put>& Vec, Graph& Graf, int& Brojac, int Max)
{
	if (Brojac == Max) return;
	Put temp;
	cin >> temp.PocTacka >> temp.KrajTacka >> temp.Paljenje;
	Putevi.push_back(temp);
	Graf.addEdge(Putevi[Brojac].PocTacka, Putevi[Brojac].KrajTacka);
	Sante[Brojac] = temp.Paljenje;
	UzmiInput(Vec, Graf, ++Brojac, Max);
}

int main() {

	int brojSanti, brojPuteva, Mika, Laza;
	int Brojac = 0;
	cin >> brojSanti >> brojPuteva;
	Graph Graf(brojSanti + 1);
	SetujSante(Sante, Brojac, brojSanti);
	Brojac = 0;

	UzmiInput(Putevi, Graf, Brojac = 0, brojPuteva);

	cin >> Mika >> Laza;
	Graf.BFS(Mika);
	cout << total << endl;
}