#include <bits/stdc++.h>
using namespace std;

vector<vector<int>> all_paths;
int num_of_paths = 0;

class Graph {
public:
	int V;
	list<int>* adj;


	Graph(int V) {
        this->V = V;
        adj = new list<int>[V];
    }

	void addEdge(int u, int v) {
        adj[u].push_back(v);
    }

	void printAllPathsUtil(int, int, bool[], vector<int>&, int&);
	void printAllPaths(int s, int d);

    ~Graph() { delete [] this->adj; }
};

void Graph::printAllPaths(int s, int d)
{
	bool* vidjenjo = new bool[V];

	vector<int> put(V, 0);
	int path_index = 0;

	for (int i = 0; i < V; i++)
		vidjenjo[i] = false;

	printAllPathsUtil(s, d, vidjenjo, put, path_index);
}

void Graph::printAllPathsUtil(int u, int d, bool poseceno[], vector<int>& put, int& path_index) {
	poseceno[u] = true; put[path_index] = u; path_index++;

	if (u == d)
        all_paths.push_back(put);
	else {
		list<int>::iterator i;
		for (i = adj[u].begin(); i != adj[u].end(); ++i)
			if (!poseceno[*i])
				printAllPathsUtil(*i, d, poseceno, put, path_index);
	}

	path_index--;
	poseceno[u] = false;
}

int main()
{
    int n, m;
    cin >> n >> m;

    bool ice[n][n];
    for(int i=0; i<n; i++)
        for(int j=0; j<n; j++)
            ice[i][j] = false;

    Graph g(n);

    int a, b; bool t;
    for(int i=0; i<m; i++) {
        cin >> a >> b >> t;
        ice[a-1][b-1] = t;
        g.addEdge(a, b);
    }


    int s, d;
    cin >> s >> d;
	g.printAllPaths(s, d);

    if(all_paths.size() == 0) { cout << -1; return 0; }

    int min_prelazaka = INT32_MAX;

    int br_promena;
    bool trenutno;
    for(int i=0; i<all_paths.size(); i++) {
        br_promena = 1;
        for(int j=0; j<all_paths[i].size() && all_paths[i][j] != 0; j++)
            if(j == 0) trenutno = all_paths[i][j];
            else if(trenutno != ice[i][j]) { br_promena++; trenutno = ice[i][j]; }

        min_prelazaka = min(min_prelazaka, br_promena);
    }


    cout << min_prelazaka << "\n";

	return 0;
}