#include <bits/stdc++.h>

using namespace std;

long long sign(long long x) { return (x > 0) - (x < 0); }
struct Point {
    long long x, y;
    Point() { x = 0, y = 0; }
    Point(long long _x, long long _y) { x = _x, y = _y; }
    Point operator - (const Point& a) const { return Point(x - a.x, y - a.y); }
};
inline long long cross(Point a, Point b) { return a.x * b.y - a.y * b.x; }
inline int orientation(Point a, Point b, Point c) { return sign(cross(b - a, c - a)); }

const int mod = 1e9 + 7;

int add(int a, int b) { a += b; return a >= mod ? a - mod : a; }
int sub(int a, int b) { a -= b; return a < 0 ? a + mod : a; }
int mul(int a, int b) { return (long long)(a) * (long long)(b) % mod; }

void sadd(int& a, int b) { a = add(a, b); }
void ssub(int& a, int b) { a = sub(a, b); }
void smul(int& a, int b) { a = mul(a, b); }

int pw(int n, int p) {
    if(!p) return 1;
    int x = pw(n, p / 2);
    smul(x, x);
    if(p & 1) smul(x, n);
    return x;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    int n;
    cin >> n;
    Point a[2 * n];
    for(int i = 0; i < n; i++) cin >> a[i].x >> a[i].y;
    sort(a, a + n, [&](Point A, Point B) {
    	if(A.y == 0) {
    		if(A.x < 0) {
    			if(B.y == 0) {
    				if(B.x > 0) return true;
    				return A.x > B.x;
    			}
    			return A.y > B.y;
    		}
    		if(B.y == 0) {
    			if(B.x < 0) return false;
    			return A.x < B.x;
    		}
    		return false;
    	}
    	if(B.y == 0) {
    		if(B.x < 0) return A.y > B.y;
    		return true;
    	}
    	if(sign(A.y) > sign(B.y)) return true;
    	if(sign(A.y) < sign(B.y)) return false;
		double ca = (double)(A.x) / A.y;
		double cb = (double)(B.x) / B.y;
    	if(A.y > 0) {
    		if(ca == cb) return A.y < B.y;
    		return ca > cb;
    	}
    	if(ca == cb) return A.y > B.y;
    	return ca > cb;
    });
    for(int i = n; i < 2 * n; i++) a[i] = a[i - n];
    int res = 0;
    for(int i = 0; i < n; i++) {
    	int l = i + 1, r = i + n - 1;
    	int ans = l;
    	while(l <= r) {
    		int mid = (l + r) >> 1;
    		if(orientation(a[i], Point(), a[mid]) == -1) {
    			ans = mid;
    			l = mid + 1;
    		} else r = mid - 1;
    	}
    	if(orientation(a[i], Point(), a[ans]) != -1) ans--;
    	sadd(res, pw(2, ans - i));
    }
    cout << sub(sub(pw(2, n), 1), res);
    return 0;
}