#include <bits/stdc++.h>

using namespace std;

long long sign(long long x) { return (x > 0) - (x < 0); }
struct Point {
    long long x, y;
    Point() { x = 0, y = 0; }
    Point(long long _x, long long _y) { x = _x, y = _y; }
    Point operator - (const Point& a) const { return Point(x - a.x, y - a.y); }
    bool operator == (Point a) const { return sign(a.x - x) == 0 && sign(a.y - y) == 0; }
    bool operator != (Point a) const { return !(*this == a); }
};
inline long long cross(Point a, Point b) { return a.x * b.y - a.y * b.x; }
inline int orientation(Point a, Point b, Point c) { return sign(cross(b - a, c - a)); }

const int mod = 1e9 + 7;

int add(int a, int b) { a += b; return a >= mod ? a - mod : a; }
int sub(int a, int b) { a -= b; return a < 0 ? a + mod : a; }
int mul(int a, int b) { return (long long)(a) * (long long)(b) % mod; }

void sadd(int& a, int b) { a = add(a, b); }
void ssub(int& a, int b) { a = sub(a, b); }
void smul(int& a, int b) { a = mul(a, b); }

int pw(int n, int p) {
    if(!p) return 1;
    int x = pw(n, p / 2);
    smul(x, x);
    if(p & 1) smul(x, n);
    return x;
}

const int N = 1e5 + 10;
int n;
Point a[2 * N];

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cin >> n;
    for(int i = 0; i < n; i++) cin >> a[i].x >> a[i].y;
    if(n == 1) {
    	cout << 0;
    	return 0;
    }
    sort(a, a + n, [&](Point A, Point B) {
    	if(A.y == 0) {
    		if(A.x < 0) {
    			if(B.y == 0) {
    				if(B.x > 0) return true;
    				return A.x > B.x;
    			}
    			return A.y > B.y;
    		}
    		if(B.y == 0) {
    			if(B.x < 0) return false;
    			return A.x < B.x;
    		}
    		return false;
    	}
    	if(B.y == 0) {
    		if(B.x < 0) return A.y > B.y;
    		return true;
    	}
    	if(sign(A.y) > sign(B.y)) return true;
    	if(sign(A.y) < sign(B.y)) return false;
		long long ca = A.x * B.y;
		long long cb = B.x * A.y;
    	if(A.y > 0) {
    		if(ca == cb) return A.y < B.y;
    		return ca > cb;
    	}
    	if(ca == cb) return A.y > B.y;
    	return ca > cb;
    });
    for(int i = n; i < 2 * n; i++) a[i] = a[i - n];
    int res = 0;
    int j = 0;
    for(int i = 0; i < n; i++) {
    	j = max(i, j);
    	while(j + 1 < 2 * n && (orientation(a[i], Point(), a[j + 1]) == -1 ||
    			(a[i].x * a[j + 1].y == a[j + 1].x * a[i].y &&
    			sign(a[i].x) == sign(a[j + 1].x) &&
    			sign(a[i].y) == sign(a[j + 1].y) &&
    			abs(a[i].x) <= abs(a[j + 1].x)) &&
    			abs(a[i].y) <= abs(a[j + 1].y)) &&
    			a[i] != a[j + 1]) j++;
    	sadd(res, pw(2, j - i));
    }
    cout << sub(sub(pw(2, n), 1), res);
    return 0;
}