using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Formacija
{
    class Program
    {
        const long mod = (long)1e9 + 7;
        struct Tacka
        {
            public long x, y;
        }
        struct Vektor
        {
            public long x, y;
        }
        static int Orijentacija(Tacka A, Tacka B, Tacka C)
        {
            Vektor a = new Vektor { x = B.x - A.x, y = B.y - A.y };
            Vektor b = new Vektor { x = C.x - A.x, y = C.y - A.y };
            long d = a.x * b.y - b.x * a.y;
            if (d == 0)
                return 0;
            if (d > 0)
                return 1;
            return -1;
        }
        static void Razmeni(List<Tacka> a, int i, int j)
        {
            Tacka T = a[i];
            a[i] = a[j];
            a[j] = T;
        }
        static long KvadratRastojanja(Tacka A, Tacka B)
        {
            return (A.x - B.x) * (A.x - B.x) + (A.y - B.y) * (A.y - B.y);
        }
        static void ProstMnogougao(List<Tacka> a)
        {
            int max = 0;
            for (int i = 1; i < a.Count; i++)
            {
                if ((a[i].x > a[max].x) || (a[i].x == a[max].x && a[i].y < a[max].y))
                    max = i;
            }
            Razmeni(a, 0, max);
            a.Sort((T1, T2) =>
            {
                int o = Orijentacija(a[0], T1, T2);
                if (o == 0)
                {
                    long d1 = KvadratRastojanja(a[0], T1);
                    long d2 = KvadratRastojanja(a[0], T2);
                    return d1.CompareTo(d2);
                }
                return -o;
            });
            int p = a.Count - 1;
            while (p > 1 && Orijentacija(a[p], a[p - 1], a[0]) == 0)
            {
                p--;
            }
            a.Reverse(p, a.Count - p);
        }
        static List<Tacka> KonveksniOmotac(List<Tacka> g)
        {
            List<Tacka> a=new List<Tacka>(g);
            ProstMnogougao(a);
            List<Tacka> b = new List<Tacka>();
            b.Add(a[0]);
            b.Add(a[1]);
            for (int i = 2; i < a.Count; i++)
            {
                while (b.Count >= 2 && Orijentacija(b[b.Count - 2], b[b.Count - 1], a[i]) != 1)
                {
                    b.RemoveAt(b.Count - 1);
                }
                b.Add(a[i]);
            }
            return b;
        }
        static bool PripadaDuzi(Tacka A, Tacka B, Tacka C)
        {
            return Orijentacija(A, B, C) == 0 &&
                Math.Min(A.x, B.x) <= C.x && C.x <= Math.Max(A.x, B.x) && 
                Math.Min(A.y,B.y) <= C.y && C.y <= Math.Max(A.y, B.y);

        }
        static bool SaIsteStrane(Tacka A, Tacka B, Tacka C, Tacka T)
        {
            int o1 = Orijentacija(A, B, C);
            int o2 = Orijentacija(A, B, T);
            if (o2 == 0)
                return true;
            return o1 == o2;
        }
        static bool TackaUTrouglu(Tacka A, Tacka B, Tacka C, Tacka T)
        {
            return SaIsteStrane(A, B, C, T) && SaIsteStrane(A, C, B, T) && SaIsteStrane(B, C, A, T);
        }
        static bool TackaUMnogouglu(List<Tacka> a, Tacka T, int l, int d)
        {
            if (d - l == 1)
                return TackaUTrouglu(a[0], a[l], a[d], T);
            int s = l + (d - l) / 2;
            if (Orijentacija(a[0], a[s], T) == 1)
                return TackaUMnogouglu(a, T, s, d);
            return TackaUMnogouglu(a, T, l, s);
        }
        static bool TackaUMnogouglu(List<Tacka> a, Tacka T)
        {
            return TackaUMnogouglu(a, T, 0, a.Count - 1);
        }
        static bool PostojiSledeciPodskup(List<Tacka> a, List<Tacka> b)
        {
            if (a.Count == 1 && a[0].x == b[b.Count - 1].x && a[0].y == b[b.Count - 1].y)
                return false;
            if (a[a.Count - 1].x == b[b.Count - 1].x && a[a.Count - 1].y == b[b.Count - 1].y)
            {
                a.RemoveAt(a.Count - 1);
                a[a.Count - 1] = b[b.IndexOf(a[a.Count - 1]) + 1];
                return true;
            }
            a.Add(b[b.IndexOf(a[a.Count - 1]) + 1]);
            return true;
        }
        static long BrPodskupova(List<Tacka> a)
        {
            Tacka T = new Tacka { x = 0, y = 0 };
            List<Tacka> b = new List<Tacka>();
            long br = 0;
            b.Add(a[0]);
            do
            {
                if ((b.Count == 1 && b[0].x == T.x && b[0].y == T.y) ||
                    (b.Count == 2 && PripadaDuzi(b[0], b[1], T)) ||
                    b.Count > 2 && TackaUMnogouglu(KonveksniOmotac(b), T))
                    br = (br + 1) % mod;
            } while (PostojiSledeciPodskup(b,a));
            return br;
        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            List<Tacka> a = new List<Tacka>();
            for (int i = 0; i < n; i++)
            {
                string[] s = Console.ReadLine().Split();
                a.Add(new Tacka { x = long.Parse(s[0]), y = long.Parse(s[1]) });
            }
            Console.WriteLine(BrPodskupova(a));
        }
    }
}