#include <bits/stdc++.h>

using namespace std;

const double EPS = 1e-6;

bool isBetween(double x1,double y1, double x2,double y2, double x3,double y3){

    int crossproduct = (y3 - y1) * (x2 - x1) - (x3 - x1) * (y2 - y1);

    if(abs(crossproduct) >EPS){
            return false;
    }

    int dotproduct = (x3 - x1) * (x2 - x1) + (y3 - y1)*(y2 - y1);
    if (dotproduct < 0){
            return false;
    }

    int squaredlengthba = (x2 - x1)*(x2 - x1) + (y2 - y1)*(y2 - y1);
    if (dotproduct > squaredlengthba){
     return false ;
    }

    return true;
}
struct Tacka {
  double x, y;
  Tacka(double x_, double y_) {
    x = x_; y = y_;
  }
};

enum Orijentacija {POZITIVNA, KOLINEARNE, NEGATIVNA};

Orijentacija orijentacija(const Tacka& A, const Tacka& B, const Tacka& C) {
  double d = (B.x-A.x)*(C.y-A.y) - (C.x-A.x)*(B.y-A.y);
  if (abs(d) < EPS)
    return KOLINEARNE;
  else if (d > EPS)
    return POZITIVNA;
  else
    return NEGATIVNA;
}

bool tackaUTrouglu(const Tacka& T,
                   const Tacka& A, const Tacka& B, const Tacka& C) {
  Orijentacija o1 = orijentacija(A, B, T);
  Orijentacija o2 = orijentacija(B, C, T);
  Orijentacija o3 = orijentacija(C, A, T);
  return o1 == o2 && o2 == o3;
}


int main() {
  ios_base::sync_with_stdio(false);
  cin.tie(0);
  int N;
  cin >> N;
  int br = 0;
  Tacka P(0,0);
  double x,y;
  vector<pair<double,double>> p(3);
  cin >> x >> y;
  p.push_back(make_pair(x,y));
  if(x==0 && y==0){
    br++;
  }
  Tacka A(x,y);
  cin >> x >> y;
  p.push_back(make_pair(x,y));
  if(x==0 && y==0){
    br++;
  }
  Tacka B(x,y);
  cin >> x >> y;
  p.push_back(make_pair(x,y));
  if(x==0 && y==0){
    br++;
  }
  Tacka C(x,y);
  if(tackaUTrouglu(P,A,B,C)){
    br++;
  }
  if(isBetween(double(p[0].first),double(p[0].second),double(p[1].first),double(p[1].second),0,0)){
    br++;
  }
  if(isBetween(double(p[0].first),double(p[0].second),double(p[2].first),double(p[2].second),0,0)){
    br++;
  }
  if(isBetween(double(p[1].first),double(p[1].second),double(p[2].first),double(p[2].second),0,0)){
    br++;
  }


  cout << br;
  return 0;
}