#include <iostream>
#include <vector>
#include <algorithm>
#include <climits>

std::vector<std::pair<int, int>> moguca_polja(int N, int M, int red, int kolona, int x, int y) {
  std::vector<std::pair<int, int>> polja = std::vector<std::pair<int, int>>();
  polja.reserve(2);
  
  // da li mozemo u sledecu kolonu
  if (kolona < M-1 && !(red == x && kolona+1 == y)) polja.push_back(std::make_pair(red, kolona+1));
  
  // da li mozemo u sledeci red
  if (red < N-1 && !(red+1 == x && kolona == y)) polja.push_back(std::make_pair(red+1, kolona));
  
  return polja;
}



std::vector<std::vector<std::pair<int, int>>> moguci_putevi(int N, int M, int red, int kolona, int x, int y) {
  std::vector<std::vector<std::pair<int, int>>> putevi;
  putevi.reserve(500);
  
  std::vector<std::vector<std::pair<int, int>>> to_process;
  to_process.reserve(1000);
  
  for(std::pair<int, int> polje : moguca_polja(N, M, red, kolona, x, y)) {
    std::vector<std::pair<int, int>> put {std::make_pair(red, kolona), polje};
    to_process.push_back(put);
  }
  
  std::vector<std::vector<std::pair<int, int>>>::iterator it = to_process.begin();
  
  
  while(!to_process.empty()) {
    std::vector<std::pair<int, int>> put = to_process[0];
    
    std::pair<int, int> zadjne_polje = put.back();
    
    for(std::pair<int, int> polje : moguca_polja(N, M, zadjne_polje.first, zadjne_polje.second, x, y)) {
      std::vector<std::pair<int, int>> novi_put = put;
      novi_put.push_back(polje);
      
      if (polje.first == N-1 && polje.second == M-1) {
        putevi.push_back(novi_put);
      } else {
        to_process.push_back(novi_put);
      }
    }
    
    to_process.erase(to_process.begin());
  }
  
  return putevi;
}



int main() {
  int N, M, Q;
  
  std::cin >> N >> M;
  
  int navijaci[N][M];
  
  for (int i = 0; i < N; i++) {
    for (int j = 0; j < M; j++) {
      std::cin >> navijaci[i][j];
    }
  }
  
  std::cin >> Q;
  
  std::pair<int, int> scenariji[Q];
  
  for (int i = 0; i < Q; i++) {
    int x, y;
    std::cin >> x >> y;
    scenariji[i] = std::make_pair(x-1, y-1);
  }
  
  
  for (std::pair<int, int> pair : scenariji) {
    int najmanje_navijaca = INT_MAX;
    
    for (std::vector<std::pair<int, int>> put : moguci_putevi(N, M, 0, 0, pair.first, pair.second)) {
      int ukupno_navijaca = 0;
      
      for (std::pair<int, int> polje : put) {
        
        if (polje.first == pair.first && polje.second == pair.second) {
          break;
        }
        
        ukupno_navijaca += navijaci[polje.first][polje.second];
      }
      
      najmanje_navijaca = std::min(najmanje_navijaca, ukupno_navijaca);
    }
    
    std::cout << najmanje_navijaca << std::endl;
  }
  
}