#include <iostream>
#include <vector>
#include <math.h>
#include <algorithm>

// Sorting Function to sort points
bool cmp(std::pair<int, int>& a,
         std::pair<int, int>& b)
{
   
    if (a.first == b.first)
        return a.second < b.second;
    return a.first < b.first;
}


int cw(std::pair<int, int>& a, std::pair<int, int>& b, std::pair<int, int>& c) {
   
    int p = a.first * (b.second - c.second) + b.first * (c.second - a.second) + c.first * (a.second - b.second);
   
    return p < 0ll;
}

int ccw(std::pair<int, int>& a, std::pair<int, int>& b, std::pair<int, int>& c) {
   
    int p = a.first * (b.second - c.second) + b.first * (c.second - a.second) + c.first * (a.second - b.second);
   
    return p > 0ll;
}
   
// Graham Scan 
std::vector<std::pair<int, int>> convex_hull(std::vector<std::pair<int, int>>& v) {
    
    std::sort(v.begin(), v.end(), cmp);
   
    int n = v.size();
    if (n <= 3)
        return v;
   
    std::pair<int, int> p1 = v[0];
    std::pair<int, int> p2 = v[n - 1];
   
    std::vector<std::pair<int, int> > up, down;
   
    up.push_back(p1);
    down.push_back(p1);
   
    for (int i = 1; i < n; i++) {
      if (i == n - 1 || !ccw(p1, v[i], p2)) {
        while (up.size() > 1 && ccw(up[up.size() - 2], up[up.size() - 1], v[i])) {
          up.pop_back();
        }
        up.push_back(v[i]);
      }
      
      if (i == n - 1 || !cw(p1, v[i], p2)) {
        while (down.size() > 1 && cw(down[down.size() - 2], down[down.size() - 1], v[i])) {
          down.pop_back();
        }
        down.push_back(v[i]);
      }
    }
   
    for (int i = down.size() - 2; i > 0; i--) up.push_back(down[i]);
   
    up.resize(unique(up.begin(), up.end()) - up.begin());
   
    return up;
}


bool contains(std::vector<std::pair<int, int>> points, std::pair<int, int> test) {
  bool result = false;
  for (int i = 0, j = points.size() - 1; i < points.size(); j = i++) {
    if ((points[i].second >= test.second) != (points[j].second >= test.second) &&
        (test.first <= (points[j].first - points[i].first) * (test.second - points[i].second) / (points[j].second-points[i].second) + points[i].first)) {
      result = !result;
     }
  }
  return result;
}


int main() {
  int N;
  
  std::cin >> N;
  
  int X[N], Y[N];
  
  for (int i = 0; i < N; i++) {
    std::cin >> X[i] >> Y[i];
  }
  
  unsigned int pow_set_size = std::pow(2, N);
  
  int ukupno = 0;
  std::pair<int, int> ankara_mesi = std::make_pair(0, 0);
  
  for (int counter = 0; counter < pow_set_size; counter++) {
      std::vector<std::pair<int, int>> points;
      
      for (int j = 0; j < N; j++) {
          if (counter & (1 << j)) {
            points.push_back(std::make_pair(X[j], Y[j]));
          }
      }
      
      if (points.size() == 1) {
        if (points[0].first == ankara_mesi.first && points[0].second == ankara_mesi.second) {
          ukupno++;
        }
      } else if (points.size() == 2) {
        std::pair<int, int> p1 = points[0];
        std::pair<int, int> p2 = points[1];
        
        double m = ((double)p1.second-p2.second)/(p1.first-p2.first);
        double b = ((double)p1.first*p2.second - p2.first*p1.second)/(p1.first-p2.first);
        
        if (ankara_mesi.second == (m*ankara_mesi.first) + b) {
          ukupno++;
        }
      } else {
        if (contains(convex_hull(points), ankara_mesi)) ukupno++;
      }
      
  }
  
  std::cout << std::fmod(1.0*ukupno, std::pow(10, 9)+7);
}