#include <iostream>
//#include <fstream>
//#include <iomanip>
//#include <cmath>
#include <algorithm>
//#include <string>
#include <vector>
//#include <utility>
//#include <map>
//#include <ctime>
//#include <cctype>
//#include <cstdlib>
//#include <limits>
//#include <numeric>
//#include <mycpp.h>

using namespace std;

typedef unsigned long long ull; 

const unsigned long MAX_NM = 1000010;

int n, m;
ull *a[MAX_NM];

class PathFeild {
	public:
		int row, column;
		PathFeild(int r, int c) {
			this->row = r;
			this->column = c;
		}
};

typedef vector<PathFeild*> vpf;

class Path {
	public:
		ull sumOfPeople;
		vpf feilds;
		Path() {
			this->sumOfPeople = 0;
		}
		Path(Path *p) {
			this->sumOfPeople = p->sumOfPeople;
			this->feilds = *(new vpf(p->feilds));
		}
		void push(int r, int c) {
			this->sumOfPeople += a[r][c];
			this->feilds.push_back(new PathFeild(r, c));
		}
		bool search(int r, int c) {
			int left = 0, right = this->feilds.size() - 1;
		  	while (left <= right) {
		    	int mid = left + (right - left) / 2;
				PathFeild* curr = this->feilds[mid];
//				int row = curr->row;
//				int column = curr->column;
//				cout << r<<c<<endl;
//				cout << "row: " << row << " column: " << column << endl;
//				cout << (curr->row == r && curr->column == c ? "true": "false") << endl;
		    	if (curr->row == r && curr->column == c)
		    		return true;
		
		    	if (curr->row > r || curr->column > c)
		      		left = mid + 1;
				else
		    		right = mid - 1;
			}
		
		  return false;
		}
};

typedef vector<Path> vp;

vp allPaths;

void generatePath(int r, int c, Path prev) {
	if(r < 0 || c < 0) return;
	Path newPath = Path(prev);
	newPath.push(r, c);
	if(r == 0 && c == 0) {
		allPaths.push_back(newPath);
		return;
	}
	generatePath(r-1, c, newPath);
	generatePath(r, c-1, newPath);
}

bool comparePaths(Path p1, Path p2) {
	return (p1.sumOfPeople < p2.sumOfPeople);
}


void printPath(int i) {
	Path p = allPaths[i];
//	cout << i << ". - sum: " << p.sumOfPeople << endl;
	for(int j = 0; j < p.feilds.size(); j++) {
		PathFeild *pf = p.feilds[j];
//		cout << pf->row << " " << pf->column << endl;
	}
//	cout << endl << endl << endl;
}

ull handleCase() {
	int r, c;
	cin >> r >> c;
//	cout << "r: " << r - 1 << " c: " << c - 1 << endl; 
	for(int i = 0; i < allPaths.size(); i++) {
		Path curr = allPaths[i];
//		printPath(i);
		bool s =  curr.search(r-1, c-1);
//		cout << "i: " << i << " S: " << (s ? "true" : "false") << endl;
		if(!s) return curr.sumOfPeople;
	}
	return 0;
}

void printPaths() {
	for(int i = 0; i < allPaths.size(); i++) {
		printPath(i);
	}
}

int main()
{
	std::ios_base::sync_with_stdio(false);
	cin >> n >> m;
	for(int i = 0; i < n; i++) {
		a[i] = new ull[m];
		for(int j = 0; j < m; j++) 
			cin >> a[i][j];
	}
	
//	for(int i = 0; i < n; i++) {
//		for(int j = 0; j < m; j++) cout << a[i][j] << " ";
//		cout << endl;
//	}		
//	cout << endl << endl;
	generatePath(n-1, m-1, new Path());
	sort(allPaths.begin(), allPaths.end(), comparePaths);
	//printPaths();
	ull q;
	cin >> q;
	ull res[q];
	for(int i = 0; i < q; i++) 
		res[i] = handleCase();
		
	for(int i = 0; i < q; i++) 
		cout << res[i] << endl;
	
}