#include <queue>
#include <iostream>

using namespace std;

struct N {
    int x, y, c;
    bool operator<(const N& o) const {
        return c > o.c;
    }
};

void dijkstra(int sx, int sy, int n, int m, vector<vector<int>>& a, vector<vector<bool>>& b, vector<vector<int>>& d) {
    std::fill(d.begin(), d.end(), vector<int>(m, -1));
    d[sx][sy] = a[sx][sy];
    priority_queue<N> q;
    q.push({sx, sy, a[sx][sy]});
    while (!q.empty()) {
        N c = q.top();
        q.pop();
        if (c.x == n - 1 && c.y == m - 1) break;
        int nx = c.x + 1;
        int ny = c.y;
        if (nx < n && !b[nx][ny]) {
            if (d[nx][ny] == -1 || d[nx][ny] > d[c.x][c.y] + a[nx][ny]) {
                d[nx][ny] = d[c.x][c.y] + a[nx][ny];
                q.push({nx, ny, d[nx][ny]});
            }
        }
        nx = c.x;
        ny = c.y + 1;
        if (ny < m && !b[nx][ny]) {
            if (d[nx][ny] == -1 || d[nx][ny] > d[c.x][c.y] + a[nx][ny]) {
                d[nx][ny] = d[c.x][c.y] + a[nx][ny];
                q.push({nx, ny, d[nx][ny]});
            }
        }
    }
}

int main() {
    int n, m;
    cin >> n >> m;
    vector<vector<int>> a(n, vector<int>(m));
    vector<vector<bool>> b(n, vector<bool>(m));
    vector<vector<int>> d(n, vector<int>(m));
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) cin >> a[i][j];
    }
    int q;
    cin >> q;
    while (q--) {
        std::fill(b.begin(), b.end(), std::vector<bool>(m, false));
        int x, y;
        cin >> x >> y;
        x--; y--;
        b[x][y] = true;
        dijkstra(0, 0, n, m, a, b, d);
        cout << d[n - 1][m - 1] << endl;
    }
    return 0;
}