#include <algorithm>
#include <vector>
#include <iostream>

struct Point {
    int x, y;
};

int cross(Point a, Point b) {
    return a.x * b.y - a.y * b.x;
}

bool convex_hull_contains_origin(std::vector<Point>& points) {
    int n = points.size();
    Point origin = {0, 0};
    for (int i = 0; i < n; i++) {
        Point a = points[i];
        Point b = points[(i + 1) % n];
        Point ab = {b.x - a.x, b.y - a.y};
        Point ao = {origin.x - a.x, origin.y - a.y};
        if (cross(ab, ao) < 0) {
            return false;
        }
    }
    return true;
}

std::vector<std::vector<Point>> subsets(std::vector<Point>& points) {
    int n = points.size();
    std::vector<std::vector<Point>> result;
    for (int mask = 0; mask < (1 << n); mask++) {
        std::vector<Point> subset;
        for (int i = 0; i < n; i++) {
            if (mask & (1 << i)) {
                subset.push_back(points[i]);
            }
        }
        result.push_back(subset);
    }
    return result;
}

int main() {
    int n;
    std::cin >> n;
    std::vector<Point> points(n);
    for (int i = 0; i < n; i++) {
        std::cin >> points[i].x >> points[i].y;
    }
    std::vector<std::vector<Point>> subsets_of_points = subsets(points);
    unsigned int count = 0;
    for (auto& subset : subsets_of_points) {
        if (convex_hull_contains_origin(subset)) {
            count++;
        }
    }
    std::cout << count << std::endl;
    return 0;
}