using System;
using System.Collections.Generic;

namespace ConsoleApplication1
{
    class Program
    {
        static int[, ,] a;
        static int M, N;
        static void Main(string[] args)
        {
            //---------------INPUT-------------------
            string[] inp = Console.ReadLine().Split();
            N = int.Parse(inp[0]);
            M = int.Parse(inp[1]);
            a = new int[N, M, 4]; //0 broj navijaca, 1 cena do njega, 2 prethodni i, 3 prethodni j


            for (int i = 0; i < N; i++)
            {
                inp = Console.ReadLine().Split();
                for (int j = 0; j < M; j++)
                {
                    a[i, j, 0] = int.Parse(inp[j]);
                    a[i, j, 1] = int.MaxValue;
                    a[i, j, 2] = -1;
                    a[i, j, 3] = -1;
                }
            }

            int Q = int.Parse(Console.ReadLine());
            //---------------------------------------

            string res = "";
            List<Point> idealanPut = new List<Point>();

            a[0, 0, 1] = a[0, 0, 0];

            HashSet<Point> openSet = new HashSet<Point>();
            HashSet<Point> closeSet = new HashSet<Point>();
            openSet.Add(new Point(0, 0));

            while (openSet.Count > 0)
            {
                Point current = MinimumCostOpen(openSet);
                if (current.i == N-1 && current.j == M-1)
                {
                    idealanPut = Path(current.i, current.j);
                }

                openSet.Remove(current);
                closeSet.Add(current);

                foreach (Point neighbor in GetNeighbors(current))
                {
                    if (closeSet.Contains(neighbor))
                    {
                        continue;
                    }

                    int tentativeGScore = a[current.i, current.j, 1] + a[neighbor.i, neighbor.j, 0];
                    if (!openSet.Contains(neighbor))
                    {
                        openSet.Add(neighbor);
                    }
                    else if (tentativeGScore >= a[neighbor.i, neighbor.j, 1])
                    {
                        continue;
                    }

                    a[neighbor.i, neighbor.j, 2] = current.i;
                    a[neighbor.i, neighbor.j, 3] = current.j;
                    a[neighbor.i, neighbor.j, 1] = tentativeGScore;
                }
            }


                for (int q = 0; q < Q; q++)
                {
                    inp = Console.ReadLine().Split();
                    
                    Point blocked = new Point(int.Parse(inp[0])-1, int.Parse(inp[1])-1);
                    if (!idealanPut.Contains(blocked))
                        res += ('\n' + "" + a[N - 1, M - 1, 1]);
                    else
                    {
                        int[, ,] aCopy = (int[,,])a.Clone();
                        openSet = new HashSet<Point>();
                        closeSet = new HashSet<Point>();
                        openSet.Add(new Point(0, 0));

                        while (openSet.Count > 0)
                        {
                            Point current = MinimumCostOpen(openSet);
                            if (current.i == N - 1 && current.j == M - 1)
                            {
                                res += ('\n' + "" + a[N - 1, M - 1, 1]);
                            }

                            openSet.Remove(current);
                            closeSet.Add(current);

                            foreach (Point neighbor in GetNeighbors(current))
                            {
                                if (neighbor.j == blocked.j && neighbor.i == blocked.i)
                                    continue;
                                if (closeSet.Contains(neighbor))
                                {
                                    continue;
                                }

                                int tentativeGScore = a[current.i, current.j, 1] + a[neighbor.i, neighbor.j, 0];
                                if (!openSet.Contains(neighbor))
                                {
                                    openSet.Add(neighbor);
                                }
                                else if (tentativeGScore >= a[neighbor.i, neighbor.j, 1])
                                {
                                    continue;
                                }

                                a[neighbor.i, neighbor.j, 2] = current.i;
                                a[neighbor.i, neighbor.j, 3] = current.j;
                                a[neighbor.i, neighbor.j, 1] = tentativeGScore;
                            }
                        }


                    }
                    
                }

            //------OUTPUT--------
            Console.WriteLine(res.Remove(0,1));
            Console.Read();
        }


        static Point MinimumCostOpen(HashSet<Point> set)
        {
            int minGScore = int.MaxValue;
            Point minGScorePoint = new Point(0,0);
            foreach (Point p in set)
            {
                int g = a[p.i, p.j, 1];
                if (g < minGScore)
                {
                    minGScore = g;
                    minGScorePoint = p;
                }
            }
            return minGScorePoint;
        }

        static List<Point> Path(int i, int j)
        {
            List<Point> l;
            if (i == 0 && j == 0)
            {
                l = new List<Point>();
                l.Add(new Point(0, 0));
                return l;
            }
            l = Path(a[i, j, 2], a[i, j, 3]);
            l.Add(new Point(i, j));
            return l;
        }

        static List<Point> GetNeighbors(Point p)
        {
            List<Point> list = new List<Point>();
            if (p.i > 0)
                list.Add(new Point(p.i - 1, p.j));

            if (p.j > 0)
                list.Add(new Point(p.i, p.j-1));

            if(p.i < N-1)
                list.Add(new Point(p.i + 1, p.j));

            if (p.j < M-1)
                list.Add(new Point(p.i, p.j + 1));
            return list;
        }

        static bool jeSiblingBlokiranog(Point neighbor, Point blocked, int[,,] aKopija)
        {
            return (aKopija[neighbor.i, neighbor.j, 2] == aKopija[blocked.i, blocked.j, 2] && aKopija[neighbor.i, neighbor.j, 3] == aKopija[blocked.i, blocked.j, 3]);
        }
    }

    class Point
    {
        public int i;
        public int j;

        public override int GetHashCode()
        {
            string s = "i" + this.i + "j" + this.j;
            return s.GetHashCode();
        }
        public override bool Equals(object obj) {
            if (obj == null)
                return false;
            return this.i == (obj as Point).i && (obj as Point).j == this.j;
        }

        public Point(int _i, int _j)
        {
            i = _i;
            j = _j;
        }

    }

}