#include <iostream>
#include <vector>
#include <math.h>
using namespace std;

struct Polje
{
    int x, y;
};

struct Putanja {
    int n;
    vector<Polje> polja;
};

vector<Putanja> insert_polje(vector<Putanja> temp, int n, Polje polje) {
    for (int x = 0; x < temp.size(); x++) {
        temp[x].polja.push_back(polje);
        temp[x].n += n;
    }
    return temp;
}

vector<Putanja> map_putanje(int n, int m, vector<vector<int>> navijaci, int i, int j, Putanja p_default) {
    vector<Putanja> putanje;
    vector<Putanja> temp;
    Polje polje;
    polje.x = i;
    polje.y = j;
    if (i < n - 1) {
        temp = insert_polje(map_putanje(n, m, navijaci, i + 1, j, p_default), navijaci[i][j], polje);
        putanje.insert(putanje.end(), temp.begin(), temp.end());
        if (j < m - 1) {
            temp = insert_polje(map_putanje(n, m, navijaci, i, j + 1, p_default), navijaci[i][j], polje);
            putanje.insert(putanje.end(), temp.begin(), temp.end());
        }
    }
    else if (j < m - 1) {
        temp = insert_polje(map_putanje(n, m, navijaci, i, j + 1, p_default), navijaci[i][j], polje);
        putanje.insert(putanje.end(), temp.begin(), temp.end());
    }
    else {
        putanje.push_back(p_default);
    }
    return putanje;
}

int partition(vector<Putanja>& putanje, int start, int end) {
    int pivot = end;
    int j = start;
    for (int i = start; i < end; ++i) {
        if (putanje[i].n < putanje[pivot].n) {
            swap(putanje[i], putanje[j]);
            ++j;
        }
    }
    swap(putanje[j], putanje[pivot]);
    return j;
}

void sort_putanje(vector<Putanja>& putanje, int start, int end) {
    if (start < end) {
        int p = partition(putanje, start, end);
        sort_putanje(putanje, start, p - 1);
        sort_putanje(putanje, p + 1, end);
    }
}

bool serach(Putanja putanja, Polje blokada, int low, int high) {
    int mid = floor((low + high) / 2);
    if (putanja.polja[mid].x == blokada.x && putanja.polja[mid].y == blokada.y) return true;
    else if (putanja.polja[mid].x <= blokada.x && putanja.polja[mid].y <= blokada.y) return serach(putanja, blokada, low, mid);
    else if (putanja.polja[mid].x >= blokada.x && putanja.polja[mid].y >= blokada.y) return serach(putanja, blokada, mid, high);
    else return false;
}

int main()
{
    int n, m;
    cin >> n >> m;
    int input;
    vector<vector<int>> navijaci;
    for (int i = 0; i < n; i++) {
        navijaci.push_back(vector<int>());
        for (int j = 0; j < m; j++) {
            cin >> input;
            navijaci[i].push_back(input);
        }
    }
    Polje stadion;
    stadion.x = n - 1;
    stadion.y = m - 1;
    Putanja p_default;
    p_default.n = navijaci[n - 1][m - 1];
    p_default.polja.push_back(stadion);
    vector<Putanja> putanje = map_putanje(n, m, navijaci, 0, 0, p_default);
    sort_putanje(putanje, 0, putanje.size() - 1);
    Polje blokada;
    int q;
    cin >> q;
    int putanja_lenght = putanje[0].polja.size();
    vector<int> r;
    for (int i = 0; i < q; i++) {
        cin >> blokada.x >> blokada.y;
        blokada.x--;
        blokada.y--;
        for (int j = 0; j < putanje.size(); j++) {
            if (!serach(putanje[j], blokada, 0, putanja_lenght - 1)) {
                r.push_back(putanje[j].n);
                break;
            }
        }
    }
    for (int i = 0; i < r.size(); i++)cout << r[i] << endl;
}