using System;

namespace ConsoleApp
{
    class Program
    {
        static void CitanjeUlaza(out int N, out int M, out long[,] lazar, out long[,] ugljesa)
        {
            string[] red = Console.ReadLine().Split(' ');
            N = int.Parse(red[0]);
            M = int.Parse(red[1]);

            lazar = new long[N, M];
            ugljesa = new long[N, M];

            CitanjeMatrice(N, M, lazar);
            CitanjeMatrice(N, M, ugljesa);
        }

        static void CitanjeMatrice(int N, int M, long[,] matrica)
        {
            for (int i = 0; i < N; i++)
            {
                string[] utakmice = Console.ReadLine().Split(' ');
                for (int j = 0; j < M; j++)
                {
                    matrica[i, j] = long.Parse(utakmice[j]);
                }
            }
        }

        static void PopunjavanjeMatrice(int N, int M, long[,] matrica1, long[,] matrica2, long[,] praznaMatrica)
        {
            for (int i = 0; i < N; i++)
            {
                for (int j = 0; j < M; j++)
                {
                    long min = Math.Min(matrica1[i, j], matrica2[i, j]);
                    long max = Math.Max(matrica1[i, j], matrica2[i, j]);

                    while (praznaMatrica[i, j] >= max)
                    {
                        for (int k = 0; k < M; k++)
                        {
                            praznaMatrica[k, j]--;
                        }
                    }

                    while (praznaMatrica[i, j] <= min)
                    {
                        for (int k = 0; k < N; k++)
                        {
                            praznaMatrica[i, k]++;
                        }
                    }

                    if (praznaMatrica[i, j] > max || praznaMatrica[i, j] < min)
                    {
                        Console.WriteLine("NE");
                        return;
                    }
                }
            }
            Console.WriteLine("DA");

            for (int o = 0; o < N; o++)
            {
                praznaMatrica[o, 0]--;
            }
            for (int o = 0; o < N; o++)
            {
                for (int p = 0; p < M; p++)
                {
                    Console.Write(praznaMatrica[o, p] + " ");
                }
                Console.WriteLine();
            }
            return;
        }

        static void Main()
        {
            int T = int.Parse(Console.ReadLine());
            for (int i = 0; i < T; i++)
            {
                CitanjeUlaza(out int N, out int M, out long[,] ugljesa, out long[,] lazar);

                long[,] novaMatrica = new long[N, M];

                PopunjavanjeMatrice(N, M, lazar, ugljesa, novaMatrica);
            }
            Console.ReadLine();
        }
    }
}