#include <iostream>

using namespace std;

int MAX = 2 * 1000000005;

int** createMatrix(int N, int M) {
	int** m = new int* [M];
	for (int i = 0; i < N; i++) {
		m[i] = new int[M];
		for (int j = 0; j < M; j++) {
			cin >> m[i][j];
		}
	}
	return m;
}

int findMaxRow(int** m, int a, int M) {
	int max = -MAX;
	for (int i = 0; i < M; i++) {
		if (m[a][i] > max) {
			max = m[a][i];
		}
	}
	return max;
}
int findMaxColumn(int** m, int N, int a) {
	int max = -MAX;
	for (int i = 0; i < N; i++) {
		if (m[i][a] > max) {
			max = m[i][a];
		}
	}
	return max;
}

void opRow(int** m, int R, int M) {
	for (int i = 0; i < M; i++) {
		m[R][i] = m[R][i] + 1;
	}

}
void opColumn(int** m, int N, int C) {
	for (int i = 0; i < N; i++) {
		m[i][C] = m[i][C] - 1;
	}
}

int findMinDiff(int** m, int** p, int N, int a) { 
	int min = MAX;
	for (int i = 0; i < N; i++) {
		if (m[i][a] - p[i][a] < min) {
			min = m[i][a] - p[i][a];
		}
	}
	return min;
}


void printMatrix(int** mat, int N, int M) {
	for (int i = 0; i < N; i++) {
		for (int j = 0; j < M; j++) {
			cout << mat[i][j] << " "; 
		}
		cout<<"\n"; 
	}
}


int main() {
    
    ios_base::sync_with_stdio(false); 
    cin.tie(0); 
    cout.tie(0); 

	int num;
	int N, M;
	cin >> num;
	int** l = nullptr, **u = nullptr, **m = nullptr;

	for (int i = 0; i < num; i++) {
		cin >> N >> M;
		l = createMatrix(N, M);
		u = createMatrix(N, M);

		m = new int*[M];
		for (int i = 0; i < N; i++) {
			m[i] = new int[M];
			for (int j = 0; j < M; j++) {
				m[i][j] = 0;
			}
		}
		int a, p;
		for (int i = 0; i < N; i++) {
			a = findMaxRow(l, i, M);
			for (int j = 0; j < a; j++) {
				opRow(m, i, M);
			}
		}
		for (int i = 0; i < M; i++) {
			a = findMaxColumn(l, N, i);
			p = findMinDiff(m, l, N, i);
			for (int j = 0; j < p; j++) {   
				opColumn(m, N, i);
			}
		}
		int flag = 0;
		for (int i = 0; i < N; i++) {
			if (flag == 1) {
				break;
			}
			for (int j = 0; j < M; j++) {
				if (u[i][j] < m[i][j]) {
					flag = 1;
					cout << "NE" << "\n";
					break;
				}
			}
		}
		if (flag == 0) {
			cout << "DA" << "\n";
			printMatrix(m, N, M);
		}
	}

	return 0;

}