using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Common;
using System.Drawing.Drawing2D;
namespace ConsoleApp2
{
    class Program
    {
        public static List<List<Point>> GetAllSubsets(Point[] points)
        {
            List<List<Point>> subsets = new List<List<Point>>();
            int n = points.Length;

            // Generate all subsets using a recursive approach
            for (int i = 0; i < (1 << n); i++)
            {
                List<Point> subset = new List<Point>();
                for (int j = 0; j < n; j++)
                {
                    if ((i & (1 << j)) > 0)
                    {
                        subset.Add(points[j]);
                    }
                }
                subsets.Add(subset);
            }

            return subsets;
        }
        public static void Main(String[] args)
        {
            int n = int.Parse(Console.ReadLine());
            Point[] p = new Point[n];
            for (int i = 0; i < n; i++)
            {
                string[] s = Console.ReadLine().Split(' ');
                p[i].X = int.Parse(s[0]);
                p[i].Y = int.Parse(s[1]);
            }
            List<List<Point>> tocke = GetAllSubsets(p);
            int br = 0;

            GraphicsPath path = new GraphicsPath();
            bool isInside = false;
            for (int i = 0; i < tocke.Count; i++)
            {
                path.AddPolygon(tocke[i]);
                isInside = path.IsPointInPath(0, 0);
                if (isInside)
                {
                    br++;
                }
            }
            Console.WriteLine(br);



        }
    }
}