using System;
using System.Linq;

namespace WorldCup2022
{
    class Program
    {
        static void Main(string[] args)
        {
// Read input
            int[] nm = Console.ReadLine().Split().Select(int.Parse).ToArray();
            int n = nm[0];
            int m = nm[1];
            int[,] a = new int[n, m];
            for (int i = 0; i < n; i++)
            {
                int[] row = Console.ReadLine().Split().Select(int.Parse).ToArray();
                for (int j = 0; j < m; j++)
                {
                    a[i, j] = row[j];
                }
            }
        // Initialize DP array
            int[,] dp = new int[n, m];
            dp[0, 0] = a[0, 0];
            for (int i = 1; i < n; i++)
            {
                dp[i, 0] = dp[i - 1, 0] + a[i, 0];
            }
            for (int j = 1; j < m; j++)
            {
                dp[0, j] = dp[0, j - 1] + a[0, j];
            }

        // Calculate minimum number of fans encountered
            for (int i = 1; i < n; i++)
            {
                for (int j = 1; j < m; j++)
                {
                    dp[i, j] = Math.Min(dp[i - 1, j], dp[i, j - 1]) + a[i, j];
                }
            }

        // Print result
            Console.WriteLine(dp[n - 1, m - 1]);
        }
    }
}