#include <stdio.h>
#include <stdlib.h>

#define MAX_N 100
#define MAX_M 100

int N, M;
int matrix[MAX_N][MAX_M];
int covered[MAX_N][MAX_M];
int dx[4] = {-1, 0, 1, 0};
int dy[4] = {0, 1, 0, -1};

void cover(int x, int y)
{
    covered[x][y] = 1;
    for (int i = 0; i < 4; i++)
    {
        int nx = x + dx[i];
        int ny = y + dy[i];
        if (nx >= 0 && nx < N && ny >= 0 && ny < M && matrix[nx][ny] && !covered[nx][ny])
        {
            cover(nx, ny);
        }
    }
}

int main()
{
    scanf("%d%d", &N, &M);
    for (int i = 0; i < N; i++)
    {
        for (int j = 0; j < M; j++)
        {
            scanf("%d", &matrix[i][j]);
        }
    }

int result = 0;
for (int i = 0; i < N; i++)
{
    for (int j = 0; j < M; j++)
    {
        if (matrix[i][j] && !covered[i][j])
        {
            result++;
            cover(i, j);
        }
    }
}

printf("%d\n", result);
return 0;
}