#include<iostream>
#include<vector>

using namespace std;



unsigned long long put(
	const vector<vector<unsigned long long>>& polja,
	unsigned int prepreka_i,
	unsigned int prepreka_j) {
	unsigned int n = polja.size();
	unsigned int m = polja[0].size();

	vector<vector<unsigned long long>> optimalne_vrednosti(n, vector<unsigned long long>(m, ULLONG_MAX));

	optimalne_vrednosti[0][0] = polja[0][0];

	for (unsigned int i = 1; i < n; i++) {
		if (prepreka_i == i && prepreka_j == 0) break; // ostaju vrednosti ULLONG_MAX
		optimalne_vrednosti[i][0] = polja[i][0] + optimalne_vrednosti[i - 1][0];
	}
	for (unsigned int j = 1; j < m; j++) {
		if (prepreka_i == 0 && prepreka_j == j) break;
		optimalne_vrednosti[0][j] = polja[0][j] + optimalne_vrednosti[0][j - 1];
	}

	for (unsigned int i = 1; i < n; i++) {
		for (unsigned int j = 1; j < m; j++) {
			if (prepreka_i == i && prepreka_j == j) continue; // ostaje vrednost ULLONG_MAX na mestu (i, j)
			unsigned long long min = optimalne_vrednosti[i - 1][j] < optimalne_vrednosti[i][j - 1] ?
				optimalne_vrednosti[i - 1][j] : optimalne_vrednosti[i][j - 1];
			optimalne_vrednosti[i][j] = polja[i][j] + min;
		}
	}

	return optimalne_vrednosti[n - 1][m - 1];
}

int main() {
	unsigned int N, M;
	std::cin >> N >> M;

	// kreiramo "prazan" vektor vektora, tj. matricu formata N x M
	vector<vector<unsigned long long>> polja(N, vector<unsigned long long>(M));

	for (unsigned int i = 0; i < N; i++) {
		for (unsigned int j = 0; j < M; j++) {
			std::cin >> polja[i][j];
		}
	}
	unsigned int Q;
	std::cin >> Q;
	vector<unsigned long long> resenja(Q);
	for (unsigned int q = 0; q < Q; q++) {

		unsigned int x, y;
		std::cin >> x >> y;
		long long resenje = put(polja, x - 1, y - 1);
		resenja[q] = resenje;
	}
	for (unsigned int q = 0; q < Q; q++) {
		std::cout << resenja[q] << std::endl;
	}
	return 0;
}