#include<iostream>
#include<vector>

using namespace std;

vector<vector<long long>> zadatak(
	const vector<vector<long long>>& L,
	const vector<vector<long long>>& U,
	string& odgovor) {
	unsigned int n = L.size();
	unsigned int m = L[0].size();

	vector<long long> br_dodavanja_1(n, 0);
	vector<long long> br_oduzimanja_1(m, 0);

	for (unsigned int k = 0; k < std::max(n, m); k++) {
		for (unsigned int i = 0; i < n; i++) {
			for (unsigned int j = 0; j < m; j++) {
				long long mij = br_dodavanja_1[i] - br_oduzimanja_1[j];
				if (mij < L[i][j]) // mora se dodati i-tom redu vrednost!
					br_dodavanja_1[i] += L[i][j] - mij;
				else if (mij > U[i][j]) // mora se oduzeti j-toj koloni vrednost
					br_oduzimanja_1[j] += mij - U[i][j];
			}
		}
	}

	for (unsigned int i = 0; i < n; i++) {
		for (unsigned int j = 0; j < n; j++) {
			long long mij = br_dodavanja_1[i] - br_oduzimanja_1[j];
			if (mij < L[i][j] || mij > U[i][j]) {
				odgovor = "NE";
				return vector<vector<long long>>();
			}
		}
	}
	odgovor = "DA";
	vector<vector<long long>> resenje(n, vector<long long>(m));
	for (unsigned int i = 0; i < n; i++) {
		for (unsigned int j = 0; j < n; j++) {
			resenje[i][j] = br_dodavanja_1[i] - br_oduzimanja_1[j];
		}
	}

	return resenje;
}

int main() {

	int T;
	cin >> T;
	vector<string> odgovri(T);
	vector<vector<vector<long long>>> matrice(T);

	for (int t = 0; t < T; t++) {
		int N, M;
		cin >> N >> M;
		vector<vector<long long>>L(N, vector<long long>(M));
		vector<vector<long long>>U(N, vector<long long>(M));
		for (int i = 0; i < N; i++) {
			for (int j = 0; j < M; j++) {
				cin >> L[i][j];
			}
		}
		for (int i = 0; i < N; i++) {
			for (int j = 0; j < M; j++) {
				cin >> U[i][j];
			}
		}
		matrice[t] = zadatak(L, U, odgovri[t]);
	}

	for (int t = 0; t < T; t++) {
		std::cout << odgovri[t] << std::endl;
		if (odgovri[t] == "DA") {
			int n = matrice[t].size();
			int m = matrice[t][0].size();
			for (int i = 0; i < n; i++) {
				for (int j = 0; j < m; j++)
					std::cout << matrice[t][i][j] << " ";
				std::cout << std::endl;
			}
		}
	}

	return 0;
}