#include <bits/stdc++.h>
using namespace std;
const double EPS = 1e-6;

struct Tacka {
  double x, y;
  Tacka(double x_, double y_) {
    x = x_; y = y_;
  }
};

// moguce orijentacije trojke tacaka
enum Orijentacija {POZITIVNA, KOLINEARNE, NEGATIVNA};

Orijentacija orijentacija(const Tacka& A, const Tacka& B, const Tacka& C) {
  double d = (B.x-A.x)*(C.y-A.y) - (C.x-A.x)*(B.y-A.y);
  if (abs(d) < EPS)
    return KOLINEARNE;
  else if (d > EPS)
    return POZITIVNA;
  else
    return NEGATIVNA;
}

bool tackaUTrouglu(const Tacka& T,
                   const Tacka& A, const Tacka& B, const Tacka& C) {
  Orijentacija o1 = orijentacija(A, B, T);
  Orijentacija o2 = orijentacija(B, C, T);
  Orijentacija o3 = orijentacija(C, A, T);
  if (o1 == KOLINEARNE || o2 == KOLINEARNE || o3 == KOLINEARNE)
    return true;
  return o1 == o2 && o2 == o3;
}

int main() {
    int n; cin >> n;
    if (n == 3) {
        int x, y;
        cin >> x >> y;
        Tacka a(x, y);
        cin >> x >> y;
        Tacka b(x, y);
        cin >> x >> y;
        Tacka c(x, y);
        Tacka m(0, 0);

        if (tackaUTrouglu(m, a, b, c))
            cout << 1 << "\n";
        else
            cout << 0 << "\n";
    }
}