#include <bits/stdc++.h>

using namespace std;

struct pt{
    long long x, y;

    pt() { };
    pt(long long x, long long y) : x(x), y(y) { };
};

int main(){

    ios_base::sync_with_stdio(0);
    cin.tie(0);

    int n;

    cin >> n;

    vector<pt> a(n);

    for(int i = 0; i < n; ++i) cin >> a[i].x >> a[i].y;
    
    auto orient = [](const pt& p1, const pt& p2, const pt& p3) -> int {
        long long x = (p2.y - p1.y) * (p3.x - p2.x) - (p2.x - p1.x) * (p3.y - p2.y);

        if(x == 0) return 0;
        
        return (x > 0) ? 1 : -1;
    };

    auto distSq = [](const pt& p1, const pt& p2) -> long long {
        return (p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y);
    };

    auto cHull = [&orient, &distSq](vector<pt>& x) -> bool {
        int minInd = 0, n = x.size();
        for(int i = 1; i < n; ++i){
            if(x[i].y < x[minInd].y) minInd = i;
            else if(x[i].y <= x[minInd].y && x[i].x < x[minInd].x) minInd = i;
        }

        swap(x[0], x[minInd]);

        sort(x.begin() + 1, x.end(), [&x, &distSq, &orient](const pt& p1, const pt& p2){
            int o = orient(x[0], p1, p2);
            if(o == 0) return distSq(x[0], p1) < distSq(x[0], p2);

            return o < 0;
        });

        int m = 1;
        for(int i = 1; i < n; ++i){
            while(i+1 < n && orient(x[0], x[i], x[i+1]) == 0) ++i;

            x[m] = x[i], ++m;
        }

        if(m < 2) return false;

        vector<pt> v;
        v.push_back(x[0]), v.push_back(x[1]), v.push_back(x[2]);

        for(int i = 3; i < m; ++i){
            while(v.size() > 1 && orient(v[v.size() - 2], v[v.size() - 1], x[i]) != -1){
                v.pop_back();
            }

            v.push_back(x[i]);
        }

        for(int i = 0; i < (int) v.size(); ++i){
            if(v[i].x == 0 && v[i].y == 0) return false;
        }

        return true;
    };

    int ans = 0;
    for(int bm = 0; bm < (1 << n); ++bm){
        vector<pt> p;
        p.emplace_back(0, 0);

        for(int i = 0; i < n; ++i){
            if(bm & (1 << i)) p.push_back(a[i]);
        }

        if(cHull(p)) ++ans;
    }

    cout << ans << '\n';
    return 0;
}