using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace zad4k2
{
    internal class Program
    {
        struct Tacka
        {
            public int x, y;
        }

        enum Orijentacija { POZITIVNA, NEGATIVNA, KOLINEARNE }

        static Orijentacija orijentacija(Tacka t0, Tacka t1, Tacka t2)
        {
            long d = (long)(t1.x - t0.x) * (long)(t2.y - t0.y) - (long)(t2.x - t0.x) * (long)(t1.y - t0.y);
            if (d > 0)
                return Orijentacija.POZITIVNA;
            else if (d < 0)
                return Orijentacija.NEGATIVNA;
            else
                return Orijentacija.KOLINEARNE;
        }

        static long kvadratRastojanja(Tacka t1, Tacka t2)
        {
            long dx = t1.x - t2.x, dy = t1.y - t2.y;
            return dx * dx + dy * dy;
        }

        static void Razmeni(List<Tacka> tacke, int i, int j)
        {
            Tacka t = tacke[i];
            tacke[i] = tacke[j];
            tacke[j] = t;
        }

        static void prostMnogougao(List<Tacka> tacke)
        {
            int max = 0;
            for (int i = 1; i < tacke.Count; i++)
                if (tacke[i].x > tacke[max].x || (tacke[i].x == tacke[max].x && tacke[i].y < tacke[max].y))
                    max = i;
            Razmeni(tacke, 0, max);
            Tacka t0 = tacke[0];
            tacke.Sort((t1, t2) => {
                Orijentacija o = orijentacija(t0, t1, t2);
                if (o == Orijentacija.KOLINEARNE)
                {
                    long d1 = kvadratRastojanja(t0, t1);
                    long d2 = kvadratRastojanja(t0, t2);
                    return d1.CompareTo(d2);
                }
                if (o == Orijentacija.POZITIVNA)
                    return -1;
                else
                    return 1;
            });
            int p = tacke.Count - 1;
            while (orijentacija(tacke[p - 1], tacke[p], t0) == Orijentacija.KOLINEARNE)
                p--;
            tacke.Reverse(p, tacke.Count - p);
        }

        static List<Tacka> konveksniOmotac(List<Tacka> tacke)
        {
            var omotac = new List<Tacka>();
            prostMnogougao(tacke);
            omotac.Add(tacke[0]);
            omotac.Add(tacke[1]);
            for (int i = 2; i < tacke.Count; i++)
            {
                while (omotac.Count >= 2 && orijentacija(omotac[omotac.Count - 2],omotac[omotac.Count - 1],tacke[i]) != Orijentacija.POZITIVNA)
                    omotac.RemoveAt(omotac.Count - 1);
                omotac.Add(tacke[i]);
            }
            return omotac;
        }
        static bool saIsteStrane(Tacka T1, Tacka T2,Tacka A1, Tacka A2)
        {
            Orijentacija o1 = orijentacija(T1, T2, A1);
            Orijentacija o2 = orijentacija(T1, T2, A2);
            if (o1 == Orijentacija.KOLINEARNE || o2 == Orijentacija.KOLINEARNE)
                return true;
            return o1 == o2;
        }

        static bool tackaUTrouglu(Tacka T1, Tacka T2, Tacka T3,Tacka A)
        {
            return saIsteStrane(T1, T2, T3, A) &&
                saIsteStrane(T1, T3, T2, A) &&
                saIsteStrane(T2, T3, T1, A);
        }

        static bool sadrzi(List<Tacka> poligon, Tacka A, int l, int d)
        {
            if (d - l == 1)
                return tackaUTrouglu(poligon[0], poligon[l], poligon[d], A);
            int s = l + (d - l) / 2;
            if (orijentacija(poligon[0], poligon[s], A) == Orijentacija.POZITIVNA)
                return sadrzi(poligon, A, s, d);
            else
                return sadrzi(poligon, A, l, s);
        }

        static bool sadrzi(List<Tacka> poligon, Tacka A)
        {
            int n = poligon.Count;
            return sadrzi(poligon, A, 1, n - 1);
        }
        static void kmsstr(List<Tacka>temena,List<Tacka> tacke, ref UInt64 br,int gr)
        {
            List<Tacka> pom = new List<Tacka>();
            Tacka p;
            p.x = 0;p.y = 0;
            for(int i = gr; i < temena.Count; i++)
            {
                pom = tacke;
                pom.Add(temena[i]);
                if(sadrzi(konveksniOmotac(pom),p))
                {
                    br++;
                    kmsstr(temena, pom, ref br, i + 1);
                }
            }
        }

        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            var tacke = new List<Tacka>();
            var pom = new List<Tacka>();
            for (int i = 0; i < n; i++)
            {
                string[] nz = Console.ReadLine().Split();
                Tacka t;
                t.x = int.Parse(nz[0]);
                t.y = int.Parse(nz[1]);
                tacke.Add(t);
            }
            UInt64 br = 0;
            for(int i=0;i<n;i++)
            {
                for (int j = i + 1; j < n; j++)
                {
                    List<Tacka> a = new List<Tacka>();
                    a.Add(tacke[i]); a.Add(tacke[j]);
                    kmsstr(tacke, a, ref br, j + 1);
                }
            }
            Console.WriteLine(br);
            Console.ReadLine();
        }
    }
}