#include <bits/stdc++.h>

#define INF 1000000001

typedef std::pair<uint64_t, uint64_t> ip;

class graph
{
private:
	uint64_t v;
	std::list<ip>* adj;
public:
	graph(uint64_t v)
		: v(v), adj(new std::list<ip>[v])
	{
	}
	
	~graph()
	{
		delete[] adj;
	}
	
	void add_edge(uint64_t u, uint64_t v, uint64_t w)
	{
		adj[u].push_back({ v, w });
	}
	
	int shortest_path(uint64_t src, uint64_t v1)
	{
		std::priority_queue<ip, std::vector<ip>, std::greater<ip>> pq;
		std::vector<uint64_t> dist(v, INF);
		
		pq.push({ 0, src });
		dist[src] = 0;
		
		while(!pq.empty())
		{
			uint64_t u = pq.top().second;
			pq.pop();
			
			for(const ip& i : adj[u])
			{
				uint64_t v = i.first;
				uint64_t w = i.second;
				
				if(dist[v] > dist[u] + w)
				{
					dist[v] = dist[u] + w;
					pq.push({ dist[v], v });
				}
			}
		}
		
		return dist[v1];
	}
};

int main()
{
	uint64_t N, M, Q;
	std::cin >> N >> M;
	
	std::vector<std::vector<uint64_t>> polja(N);
	
	for(uint64_t i = 0; i < N; i++)
	{
		for(uint64_t j = 0; j < M; j++)
		{
			uint64_t x;
			std::cin >> x;
			polja[i].push_back(x);
		}
	}
	
	std::cin >> Q;
	std::vector<ip> zabr(Q);
	for(uint64_t i = 0; i < Q; i++)
	{
		std::cin >> zabr[i].first;
		std::cin >> zabr[i].second;
	}
	
	for(uint64_t x = 0; x < Q; x++)
	{
		graph g(N * M + 1);
		
		for(uint64_t i = 0; i < N; i++)
		{
			for(uint64_t j = 0; j < M; j++)
			{
				if(i == zabr[x].first - 1 && j == zabr[x].second - 1)
					continue;
				
				if(j != M - 1)
					g.add_edge(polja[i][j], polja[i][j + 1], polja[i][j + 1]);
				
				if(i != N - 1)
					g.add_edge(polja[i][j], polja[i + 1][j], polja[i + 1][j]);
			}
		}
		
		std::cout << g.shortest_path(1, N * M) + polja[0][0] << "\n";
	}
	
	return 0;
}