#include <bits/stdc++.h>
#define ll long long

using namespace std;

typedef pair<int, int> Position;
typedef pair<ll, Position> PQType;

int N, M, Q;

namespace case1 // N = 2
{
  void solve(vector<vector<ll>> &grid)
  {
    ll a1[M + 1];
    ll a2[M + 1];
    ll p1[M + 1];
    ll p2[M + 1];
    a1[2] = grid[1][1] + grid[2][1];
    a2[2] = grid[2][M] + grid[1][M];
    p1[1] = grid[1][1];
    p2[1] = grid[2][1];

    for (int i = 2; i <= M; i++)
    {
      p1[i] = p1[i - 1] + grid[1][i];
      p2[i] = p2[i - 1] + grid[2][i];
    }

    for (int i = 3; i <= M; i++)
    {
      a1[i] = min(a1[i - 1] + grid[2][i - 1], p1[i - 1] + grid[2][i - 1]);
      a2[i] = min(a2[i - 1] + grid[1][M - i + 2], p2[M] - p2[M - i + 1] + grid[1][M - i + 2]);
    }

    cin >> Q;
    for (int q = 0; q < Q; q++)
    {
      int x, y;
      cin >> x >> y;

      if (x == 1)
      {
        cout << (a1[y] + (p2[M] - p2[y - 1])) << "\n";
      }
      else
      {
        cout << (a2[M - y + 1] + p1[y]) << "\n";
      }
    }
  }
}

namespace case2
{

  void solve(vector<vector<ll>> &grid)
  {
    vector<vector<bool>> visited(N + 1, vector<bool>(M + 1));

    cin >> Q;

    for (int q = 0; q < Q; q++)
    {
      int x, y;
      cin >> x >> y;

      ll dp[N + 1][M + 1];

      ll tmp = grid[x][y];

      dp[1][1] = grid[1][1];
      grid[x][y] = 1e18;

      for (int i = 2; i <= N; i++)
      {
        dp[i][1] = dp[i - 1][1] + grid[i][1];
      }

      for (int j = 2; j <= M; j++)
      {
        dp[1][j] = dp[1][j - 1] + grid[1][j];
      }

      for (int i = 2; i <= N; i++)
      {
        for (int j = 2; j <= M; j++)
        {
          dp[i][j] = min(dp[i - 1][j], dp[i][j - 1]) + grid[i][j];
        }
      }

      grid[x][y] = tmp;

      cout << dp[N][M] << "\n";
    }
  }
}

int main()
{
  ios_base::sync_with_stdio(0);
  cin.tie(0);

  cin >> N >> M;

  vector<vector<ll>> grid(N + 1, vector<ll>(M + 1));

  for (int i = 1; i <= N; i++)
  {
    for (int j = 1; j <= M; j++)
    {
      cin >> grid[i][j];
    }
  }

  if (N == 2)
  {
    case1::solve(grid);
  }
  else
  {
    case2::solve(grid);
  }
}