#include <bits/stdc++.h>
#define ll long long
#define ld long double
#define EPS 1e-9

using namespace std;

struct pt
{
  ll x, y;
  pt() {}
  pt(ll _x, ll _y) : x(_x), y(_y) {}

  bool operator==(const pt &p) const
  {
    return (x == p.x && y == p.y);
  }
};

struct line
{
  pt p1, p2;
  line() {}
  line(pt _p1, pt _p2) : p1(_p1), p2(_p2) {}
};

ll ans = 0;
pt ronaldo_je_bolji777777777(0ll, 0ll);

ld area(pt p1, pt p2, pt p3)
{
  return abs((p1.x * (p2.y - p3.y) + p2.x * (p3.y - p1.y) + p3.x * (p1.y - p2.y)) / 2.0);
}

ld dist(pt p1, pt p2)
{
  return sqrt((p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y));
}

bool check(pt p1, pt p2, pt p3, pt p)
{
  ld A = area(p1, p2, p3);
  ld A1 = area(p, p2, p3);
  ld A2 = area(p1, p, p3);
  ld A3 = area(p1, p2, p);
  return fabs(A - (A1 + A2 + A3)) < EPS;
}

bool check(line l, pt p)
{
  return fabs((dist(l.p1, p) + dist(l.p2, p)) - dist(l.p1, l.p2)) < EPS;
}

void process(vector<pt> &points)
{
  ll n = points.size();
  if (n == 1)
  {
    ans += points[0] == ronaldo_je_bolji777777777;
  }
  else if (n == 2)
  {
    ans += check(line(points[0], points[1]), ronaldo_je_bolji777777777);
  }
  else if (n == 3)
  {
    ans += check(points[0], points[1], points[2], ronaldo_je_bolji777777777);
  }
}

void subsets(vector<pt> &points, vector<pt> &sb, int index)
{
  int N = points.size();

  for (int i = 1; i < (1 << N); i++)
  {
    vector<pt> subset;
    for (int j = 0; j < N; j++)
    {
      if (i & (1 << j))
      {
        subset.push_back(points[j]);
      }
    }
    process(subset);
  }

  return;
}

int main()
{
  ios_base::sync_with_stdio(0);
  cin.tie(0);

  int N;
  cin >> N;

  if (N > 3)
  {
    cout << 0 << "\n";
    return 0;
  }

  vector<pt> points(N);
  for (int i = 0; i < N; i++)
  {
    cin >> points[i].x >> points[i].y;
  }

  vector<pt> sb;
  subsets(points, sb, 0);

  cout << ans << "\n";
}