#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>

#define ll long long
#define M_PI 3.14159265358979323846

using namespace ::std;

const ll modl = 1e9 + 7;

typedef struct
{
    int x, y;
} Point;

bool provera(vector<Point> &pts)
{
    int n = pts.size();
    if (n < 2)
        return false;
    vector<double> uglovi(n);
    for (int i = 0; i < n; i++)
    {
        uglovi[i] = atan2((double)pts[i].y, (double)pts[i].x);
        if (uglovi[i] < 0)
            uglovi[i] = 2 * M_PI + uglovi[i];
    }
    sort(uglovi.begin(), uglovi.end());
    double ukupan = uglovi[n - 1] - uglovi[0];
    for (int i = 1; i < n; i++)
    {
        if (uglovi[i] - uglovi[i - 1] >= M_PI)
            return false;
    }
    return ukupan >= M_PI;
}

void prodjiSvePodskupove(vector<Point> pts, vector<Point> &ps, int ind, int &count)
{
    if (!ps.empty())
    {
        count += provera(ps);
    }

    for (int i = ind; i < pts.size(); i++)
    {
        ps.push_back(pts[i]);
        prodjiSvePodskupove(pts, ps, i + 1, count);
        ps.pop_back();
    }
}

ll binpow(ll a, ll b)
{
    a %= modl;
    long long res = 1;
    while (b > 0)
    {
        if (b % 2 == 1)
            res = res * a % modl;
        a = a * a % modl;
        b /= 2;
    }
    return res;
}

bool compPoint(Point a, Point b)
{
    return a.x < b.x;
}

void solve()
{
    int n;
    cin >> n;
    vector<Point> points(n);
    for (auto &i : points)
        cin >> i.x >> i.y;
    if (n <= 18)
    {
        int count = 0;
        vector<Point> ps;
        prodjiSvePodskupove(points, ps, 0, count);
        cout << count << '\n';
    }
    else
    {
        vector<Point> pn1, pp1;
        for (auto &i : points)
        {
            if (i.y == -1)
                pn1.push_back(i);
            else if (i.y == 1)
                pp1.push_back(i);
        }
        sort(pn1.begin(), pn1.end(), compPoint);
        sort(pp1.begin(), pp1.end(), compPoint);
        ll sum = 0;
        for (int i = 0; i < pp1.size(); i++)
        {
            int lq = lower_bound(pn1.begin(), pn1.end(), (Point){-pp1[i].x, 1}, compPoint) - pn1.begin();
            if (pn1[lq].x <= -pp1[i].x)
                lq++;
            int r = pn1.size() - lq;
            sum = (sum + (binpow(2, lq) - 1) * (binpow(2, r) - 1) % modl) * (binpow(2, i + 1) - 1) % modl;
        }
        cout << sum << '\n';
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    solve();
    return 0;
}