#include <bits/stdc++.h>

#define ll long long
#define x first
#define y second
#define point pair<int, int>

using namespace std;

const ll mod = 1e9 + 7;

int orientation(point p, point q, point r) {

    int o = (q.x - p.x) * (r.y - q.y)
        - (r.x - q.x) * (q.y - p.y);
    if(o == 0)
        return 0;
    return (o > 0 ? 1 : -1);
}

void ConvexHull(point pnt[], int n, vector<point> &hull) {

    int k = 0;
    vector<point> up;
    for(int i = 0; i < n; i++) {
        while(k >= 2 && orientation(up[k - 2], up[k - 1], pnt[i]) >= 0) {
            up.pop_back();
            k--;
        }
        up.push_back(pnt[i]);
        k++;
    }

    k = 0;
    vector<point> down;
    for(int i = 0; i < n; i++) {
        while(k >= 2 && orientation(down[k - 2], down[k - 1], pnt[i]) <= 0) {
            down.pop_back();
            k--;
        }
        down.push_back(pnt[i]);
        k++;
    }

    for(int i = 0; i < up.size(); i++)
        hull.push_back(up[i]);
    for(int i = down.size() - 2; i > 0; i--)
        hull.push_back(down[i]);
}

bool inside(point p, vector<point> poly) {

    int n = poly.size();
    if(n == 1)
        return p == poly[0];

    for(int i = 0; i < n; i++) {
        point p1 = poly[i], p2 = poly[(i + 1) % n];

        if(orientation(p1, p2, p) == 0 && ((p1.x <= p.x && p.x <= p2.x) || ((p2.x <= p.x && p.x <= p1.x))))
            return true;
        
        if(orientation(p1, p2, p) == 1)
            return false;
    }
    return true;
}

int main() {

    int n;
    cin >> n;

    point pnt[n];
    for(int i = 0; i < n; i++)
        cin >> pnt[i].x >> pnt[i].y;
    sort(pnt, pnt + n);

    ll ans = 0;
    for(int mask = 1; mask < (1 << n); mask++) {
        int m = __builtin_popcount(mask), br = 0;
        point p[m];
        for(int i = 0; i < n; i++)
            if(mask & (1 << i))
                p[br++] = pnt[i];

        vector<point> poly;
        ConvexHull(p, m, poly);
        
        if(inside({0, 0}, poly))
            ans = (ans + 1) % mod;
    }
    cout << ans << endl;
    return 0;
}