#include <bits/stdc++.h>

#define ll long long
#define pb push_back
#define x first
#define y second
#define point pair<ll, ll>

using namespace std;

const ll mod = 1e9 + 7;

int orientation(point p, point q, point r) {

    int o = (q.x - p.x) * (r.y - q.y)
        - (r.x - q.x) * (q.y - p.y);
    if(o == 0)
        return 0;
    return (o > 0 ? 1 : -1);
}

void ConvexHull(point pnt[], int n, vector<point> &hull) {

    int k = 0;
    vector<point> up;
    for(int i = 0; i < n; i++) {
        while(k >= 2 && orientation(up[k - 2], up[k - 1], pnt[i]) >= 0) {
            up.pop_back();
            k--;
        }
        up.pb(pnt[i]);
        k++;
    }

    k = 0;
    vector<point> down;
    for(int i = 0; i < n; i++) {
        while(k >= 2 && orientation(down[k - 2], down[k - 1], pnt[i]) <= 0) {
            down.pop_back();
            k--;
        }
        down.pb(pnt[i]);
        k++;
    }

    for(int i = 0; i < up.size(); i++)
        hull.pb(up[i]);
    for(int i = down.size() - 2; i > 0; i--)
        hull.pb(down[i]);
}

bool inside(point p, vector<point> poly) {

    int n = poly.size();
    if(n == 1)
        return p == poly[0];

    for(int i = 0; i < n; i++) {
        point p1 = poly[i], p2 = poly[(i + 1) % n];

        if(orientation(p1, p2, p) == 0 && ((p1.x <= p.x && p.x <= p2.x) || ((p2.x <= p.x && p.x <= p1.x))))
            return true;
        
        if(orientation(p1, p2, p) == 1)
            return false;
    }
    return true;
}

ll mul(ll a, ll b) {

    return (a * b) % mod;
}

ll add(ll a, ll b) {
    a += b;
    if(a >= mod)
        a -= mod;
    return a;
}

ll mod_pow(int x, int n) {

    if(n == 0)
        return 1;
    if(n % 2)
        return mul(mod_pow(x, n - 1), x);
    ll temp = mod_pow(x, n / 2);
    temp = mul(temp, temp);
    return temp;
}

void solve(point p[], int n) {

    sort(p + 1, p + n);
    point pnt(0, 0);

    int index = n;
    for(int i = 1; i < n; i++) {
        if(orientation(p[0], p[i], pnt) == 0) {
            int l = i - 1, r = n - i - 1;
            // cout << l << " " << r << endl;
            cout << add(mod_pow(2, l + r), mul(mod_pow(2, l) - 1, mod_pow(2, r) - 1)) << endl;
            return;
        }
        if(orientation(p[0], p[i], pnt) == -1) {
            index = i;
            break;
        }
    }

    int l = index - 1, r = n - index;
    cout << mul(mod_pow(2, l) - 1, mod_pow(2, r) - 1) << endl;
}

int main() {

    int n;
    cin >> n;

    bool tst = true;
    point pnt[n];
    for(int i = 0; i < n; i++) {
        cin >> pnt[i].x >> pnt[i].y;
        if(i == 0 && pnt[i].y != 1)
            tst = false;
        else if(pnt[i].y != -1)
            tst = false;
    }
    if(tst) {
        solve(pnt, n);
        return 0;
    }

    sort(pnt, pnt + n);

    ll ans = 0;
    for(int mask = 1; mask < (1 << n); mask++) {
        int m = __builtin_popcount(mask), br = 0;
        point p[m];
        for(int i = 0; i < n; i++)
            if(mask & (1 << i))
                p[br++] = pnt[i];

        vector<point> poly;
        ConvexHull(p, m, poly);

        if(inside({0, 0}, poly))
            ans = (ans + 1) % mod;
    }
    cout << ans << endl;
    return 0;
}