#include <bits/stdc++.h>

using namespace std;

const int MAX_VECT_SIZE = 1000000;
int n, m;
vector<long long> v[MAX_VECT_SIZE + 1], l[MAX_VECT_SIZE + 1], r[MAX_VECT_SIZE + 1];
vector<long long> max_val_l[MAX_VECT_SIZE + 1], max_val_r[MAX_VECT_SIZE + 1];

void preprocess_tl() {
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            if (i == 0) {
                if (j == 0) {
                    l[i].push_back(v[i][j]);
                }
                else {
                    l[i].push_back(l[i].back() + v[i][j]);
                }
            }
            else {
                if (j == 0) {
                    l[i].push_back(l[i-1][0] + v[i][j]);
                }
                else {
                    l[i].push_back(min(l[i-1][j], l[i][j-1]) + v[i][j]);
                }
            }
        }
    }
}

void preprocess_br() {
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            r[i].push_back(0);
        }
    }

    for (int i = n-1; i >= 0; i--) {
        for (int j = m-1; j >= 0; j--) {
            if (i == n-1) {
                if (j == m-1) {
                    r[i][j] = v[i][j];
                }
                else {
                    r[i][j] = r[i][j+1] + v[i][j];
                }
            }
            else {
                if (j == m-1) {
                    r[i][j] = r[i+1][m-1] + v[i][j];
                }
                else {
                    r[i][j] = min(r[i+1][j], r[i][j+1]) + v[i][j];
                }
            }
        }
    }
}

void create_min_val() {
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            max_val_l[i].push_back(1e18);
            max_val_r[i].push_back(1e18);
        }
    }

    for (int i =  1; i < n; i++) {
        for (int j = 0; j < m; j++) {
            if (j == 0) {
                max_val_l[i][j] = l[i-1][j] + r[i][j];
            }
            else {
                max_val_l[i][j] = min(max_val_l[i][j-1], l[i-1][j] + r[i][j]);
            }
        }
    }

    for (int i = n-2; i >= 0; i--) {
        for (int j = m-1; j >= 0; j--) {
            if (j == m-1) {
                max_val_r[i][j] = r[i+1][j] + l[i][j];
            }
            else {
                max_val_r[i][j] = min(max_val_r[i][j+1], r[i+1][j] + l[i][j]);
            }
        }
    }
}

int main() {
    ios::sync_with_stdio(false);cin.tie(0);cout.tie(0);

    cin >> n >> m;

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            int x; cin >> x;
            v[i].push_back(x);
        }
    }

    preprocess_tl();
    preprocess_br();

    /*
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            cout << l[i][j] << " ";
        }
        cout << "\n";
    }

    cout << "\n";
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            cout << r[i][j] << " ";
        }
        cout << "\n";
    }
    cout << "\n";
    */


    create_min_val();

    /*
    cout << "\n";
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            cout << max_val_l[i][j] << " ";
        }
        cout << "\n";
    }
    cout << "\n";
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            cout << max_val_r[i][j] << " ";
        }
        cout << "\n";
    }
    */

    int q;
    cin >> q;
    while (q--) {
        int x, y;
        cin >> x >> y;
        x--, y--;

        long long ans = 1e18;
        if (x+1 < n and y-1>=0) {
            ans = min(ans, max_val_l[x+1][y-1]);
        }
        if (x-1 >= 0 and y+1<m) {
            ans = min(ans, max_val_r[x-1][y+1]);
        }

        cout << ans << "\n";
    }
    return 0;
}

/*
3 4
1 2 3 4
5 6 7 8
9 10 11 12
2
1 2
2 4

4 4
0 5 0 1
2 0 1 0
8 1 0 1
1 0 1 0
4
*/