using System;
using System.Globalization;
using System.Security.Cryptography.X509Certificates;

namespace Zad3
{
	class Program
	{
		static long[,] BrojSusreta(int[,] navijaci)
		{
			long[,] ret = new long[navijaci.GetLength(0) + 1, navijaci.GetLength(1) + 1];
			int xl = navijaci.GetLength(0) + 1;
			int yl = navijaci.GetLength(1) + 1;

			ret[1, 1] = navijaci[0, 0];

			for (int i = 1; i < xl; i++)
			{
				ret[i, 0] = 0;
			}
			for (int i = 2; i < xl; i++)
			{
				ret[i, 1] = navijaci[i - 1, 0] + ret[i - 1, 1];
			}

			for (int i = 1; i < yl; i++)
			{
				ret[0, i] = 0;
			}
			for (int i = 2; i < yl; i++)
			{
				ret[1, i] = navijaci[0, i - 1] + ret[1, i - 1];
			}
			for (int x = 2; x < xl; x++)
			{
				for(int y = 2; y < yl; y++)
				{
					ret[x, y] = navijaci[x - 1, y - 1] + Math.Min(ret[x - 1, y], ret[x, y - 1]);
				}
			}
			return ret;
		}
		static void KopirajMatricu(long[,] zaKopirati, long[,] mestoKopiranja)
		{
			for(int x = 0; x < zaKopirati.GetLength(0); x++)
			{
				for(int y = 0; y < zaKopirati.GetLength(1); y++)
				{
					mestoKopiranja[x, y] = zaKopirati[x, y];
				}
			}
		}
		static long[,] BrojSusreta(int[,] navijaci, long[,] susreti, int x, int y)
		{
			long[,] ret = new long[susreti.GetLength(0), susreti.GetLength(1)];
			KopirajMatricu(susreti, ret);
			ret[x, y] = long.MaxValue;
			for(int i = x + 1; i < ret.GetLength(0); i++)
			{
				if (y == 1 && ret[i - 1, y] == long.MaxValue)
				{
					ret[i, y] = long.MaxValue;
				}
				else
				{
					ret[i, y] = navijaci[i - 1, y - 1] + Math.Min(ret[i - 1, y], ret[i, y - 1]);
				}
			}
			for(int i = y + 1; i < ret.GetLength(1); i++)
			{
				if(x == 1 && ret[x, i - 1] == long.MaxValue)
				{
					ret[x, i] = long.MaxValue;
				}
				else
				{
					ret[x, i] = navijaci[x - 1, i - 1] + Math.Min(ret[x - 1, i], ret[x, i - 1]);
				}
			}
			for(int x1 = x + 1; x1 < ret.GetLength(0); x1++)
			{
				for(int y1 = y + 1; y1 < ret.GetLength(1); y1++)
				{
					ret[x1, y1] = navijaci[x1 - 1, y1 - 1] + Math.Min(ret[x1 - 1, y1], ret[x1, y1 - 1]);
				}	
			}
			return ret;
		}
		static void IspisiMatricu(long[,] m)
		{
			for(int j = 0; j < m.GetLength(1); j++)
			{
				for( int i = 0; i < m.GetLength(0); i++)
				{
					Console.Write(m[i, j] + " ");
				}
				Console.WriteLine();
			}
		}
		static void IspisiMatricu(int[,] m)
		{
			for (int j = 0; j < m.GetLength(1); j++)
			{
				for (int i = 0; i < m.GetLength(0); i++)
				{
					Console.Write(m[i, j] + " ");
				}
				Console.WriteLine();
			}
		}
		static void Main(string[] args)
		{
			int N, M, Q;
			string[] input = Console.ReadLine().Split();
			N = int.Parse(input[0]);
			M = int.Parse(input[1]);
			int[,] navijaci = new int[N, M];
			for(int x = 0; x < N; x++)
			{
				input = Console.ReadLine().Split();
				for(int y = 0; y < M; y++)
				{
					navijaci[x, y] = int.Parse(input[y]);
				}
			}
			long[,] susreti = BrojSusreta(navijaci);
			Q = int.Parse(Console.ReadLine());
			for(int i = 0; i < Q; i++)
			{
				input = Console.ReadLine().Split();
				int x = int.Parse(input[0]);
				int y = int.Parse(input[1]);
				long[,] brojSusreta = BrojSusreta(navijaci, susreti, x, y);
				Console.WriteLine(brojSusreta[N, M]);
			}
		}
	}
}