using System;
using System.Collections.Generic;

namespace PointInoblik
{
    class Program
    {
        static void Main(string[] args)
        {
      
            int n = int.Parse(Console.ReadLine()), count = 0;
            double eps = 1e-10;
            List<Tacka> oblik = new List<Tacka>();
            for (int i = 0; i < n; i++)
            {
                var s = Console.ReadLine().Split();
            
                int x = int.Parse(s[0]);
                int y = int.Parse(s[1]);
                oblik.Add(new Tacka(x, y));
            }

            List<List<Tacka>> tkombinacije = new List<List<Tacka>>();
            for (int length = 1; length <= n; length++)
            {
                Generisi(n, new int[length], 0, 0, tkombinacije, oblik);
            }

            foreach (List<Tacka> kombinacija in tkombinacije)
            {

                Tacka tacka = new Tacka(0, 0);
                if (Proveri(tacka, kombinacija))
                {
                    count++;
                   
                } else{
                  
                }
            }
            Console.Write(count);
        }
        static void Generisi(int N, int[] kombinacija, int kindex, int start, List<List<Tacka>> combinations, List<Tacka> oblik)
        {
            
            if (kindex == kombinacija.Length)
            {
                combinations.Add(new List<Tacka>(kombinacija.Length));
                for (int i = 0; i < kombinacija.Length; i++)
                {
                    combinations[combinations.Count - 1].Add(oblik[kombinacija[i]]);
                }
                return;
            }


            for (int i = start; i < N; i++)
            {
                kombinacija[kindex] = i;
                Generisi(N, kombinacija, kindex + 1, i + 1, combinations, oblik);
            }
        }
static bool Proveri(Tacka tacka, List<Tacka> oblik)
{
   
    double minX = double.PositiveInfinity, maxX = double.NegativeInfinity, minY = double.PositiveInfinity, maxY = double.NegativeInfinity;
    for (int i = 0; i < oblik.Count; i++)
    {
        minX = Math.Min(minX, oblik[i].X);
        maxX = Math.Max(maxX, oblik[i].X);
        minY = Math.Min(minY, oblik[i].Y);
        maxY = Math.Max(maxY, oblik[i].Y);
    }
    if (tacka.X < minX || tacka.X > maxX || tacka.Y < minY || tacka.Y > maxY)
    {

        return false;
    }

    int presek = 0;
    for (int i = 0, j = oblik.Count - 1; i < oblik.Count; j = i++)
    {
        if (oblik[i].Y > tacka.Y != oblik[j].Y > tacka.Y &&
            tacka.X < (oblik[j].X - oblik[i].X) * (tacka.Y - oblik[i].Y) / (oblik[j].Y - oblik[i].Y) + oblik[i].X)
        {
            presek++;
        }
    }
    return presek % 2 == 1;
}

}
    class Tacka
    {
        public int X { get; set; }
        public int Y { get; set; }

        public Tacka(int x, int y)
        {
            X = x;
            Y = y;
        }
    }
}