#include <iostream>
#include <vector>

using namespace std;


int minPathSum(vector<vector<long long>>& grid) {
        //Fast I/O in C++
        ios_base::sync_with_stdio(false);
        cin.tie(NULL);

        int rows = grid.size();
        if(rows==0)
            return 0;
        int cols = grid[0].size();
        vector<vector<long long>> dp(rows,vector<long long>(cols,0));
        int i,j;

        dp[0][0] = grid[0][0];  //1st element is starting point
        //Fill 1st row
        for(i=1;i<cols;++i)
            dp[0][i] = dp[0][i-1] + grid[0][i];

        //Fill 1st Col
        for(i=1;i<rows;++i)
            dp[i][0] = dp[i-1][0] + grid[i][0];

        //Now fill the rest of the cell
        for(i=1;i<rows;++i)
        {
            for(j=1;j<cols;++j)
                dp[i][j] = grid[i][j] + min(dp[i-1][j],dp[i][j-1]);
        }
        return dp[rows-1][cols-1];
    }


int main()
{
    int n,m,q,input, red, kolona, a, b;
    cin>>n>>m;

    vector<long long> v(n, 1);
    vector<vector<long long>> grid(m, v);

    for (int i = 0; i<n; i++)
    {
        for (int j = 0; j<m; j++)
        {
            cin>>input;
            grid[i][j] = input;
        }
    }
    cin>>q;

    vector<int> v_of_ones(q, 1);
    vector<vector<int>> Q(2, v_of_ones);

    for (int i = 0; i < q; i++)
    {
        cin>>red>>kolona;
        Q[i][0] = red - 1;
        Q[i][1] = kolona - 1;
    }



    // U ovoj petlji resavamo zadatak
    for (int i = 0; i < q; i++)
    {
        // postavi vrednost polja u gridu na +beskonacno
        a = Q[i][0];
        b = Q[i][1];

        int prethodna_upisana_vrednost = grid[a][b];
        cout << "Prethodna vrednost: " << prethodna_upisana_vrednost << endl;

        long long& x = grid[a][b];
        x = 1000000000000; //1e12

        cout<< "Trenutna vrednost u grid-u: " << grid[a][b] << endl;

        int duzinaPuta = minPathSum(grid);
        cout << duzinaPuta<<endl;

        //grid[a][b]=prethodna_upisana_vrednost;
        x = prethodna_upisana_vrednost;
    }
}