#include <iostream>
#include <list>
using namespace std;

struct Point {
    int x, y;
};

struct line {
    Point p1, p2;
};

bool onLine(line l1, Point p)
{
    if (p.x <= max(l1.p1.x, l1.p2.x)
        && p.x <= min(l1.p1.x, l1.p2.x)
        && (p.y <= max(l1.p1.y, l1.p2.y)
            && p.y <= min(l1.p1.y, l1.p2.y)))
        return true;

    return false;
}

int direction(Point a, Point b, Point c)
{
    int val = (b.y - a.y) * (c.x - b.x)
        - (b.x - a.x) * (c.y - b.y);
    if (val == 0)
        return 0;
    else if (val < 0)
        return 2;
    return 1;
}

bool isIntersect(line l1, line l2)
{
    int dir1 = direction(l1.p1, l1.p2, l2.p1);
    int dir2 = direction(l1.p1, l1.p2, l2.p2);
    int dir3 = direction(l2.p1, l2.p2, l1.p1);
    int dir4 = direction(l2.p1, l2.p2, l1.p2);
    if (dir1 != dir2 && dir3 != dir4)
        return true;
    if (dir1 == 0 && onLine(l1, l2.p1))
        return true;
    if (dir2 == 0 && onLine(l1, l2.p2))
        return true;
    if (dir3 == 0 && onLine(l2, l1.p1))
        return true;
    if (dir4 == 0 && onLine(l2, l1.p2))
        return true;

    return false;
}

bool checkInside(Point poly[], int n, Point p)
{
    if (n < 3)
        return false;
    line exline = { p, { 9999, p.y } };
    int count = 0;
    int i = 0;
    do {
        line side = { poly[i], poly[(i + 1) % n] };
        if (isIntersect(side, exline)) {
            if (direction(side.p1, p, side.p2) == 0)
                return onLine(side, p);
            count++;
        }
        i = (i + 1) % n;
    } while (i != 0);
    return count & 1;
}
int allPossibleSubset(Point arr[], int n, Point p)
{
    int count = pow(2, n);
    int inside = 0;
    
    int l = 0;
    for (int i = 0; i < count; i++) {
        Point* subset = new Point[n];
        for (int j = 0; j < n; j++) {
            if ((i & (1 << j)) != 0) {
                subset[l] = arr[j];
                l++;
            }
        }
        l++;
        if (checkInside(subset, l, p)) {
            inside++;
        }
        l = 0;
        delete[] subset;
    }
    return inside;
}
int main()
{
    int N;
    cin >> N;
    int unutra;
    Point* poly = new Point[N];
    for (int i = 0; i < N; i++)
        cin >> poly[i].x >> poly[i].y;
    Point p = { 0,0 };
    unutra=allPossibleSubset(poly, N, p);
    cout << unutra % (1000000007);
    return 0;
}