from itertools import chain, combinations
from math import atan2

def sort_points(points):
    angles = []
    for p in points:
        if p[0] == 0:
            angle = 0
        else:
            angle = atan2(p[1], p[0])
        angles.append(angle)
    return [x for _, x in sorted(zip(angles, points))]

def on_line(a, p, b):
    return p[0] <= max(a[0], b[0]) and p[0] >= min(a[0], b[0]) and p[1] <= max(a[1], b[1]) and p[1] >= min(a[1], b[1])

def direction(a, b, c):
    k = (b[1] - a[1]) * (c[0] - b[0]) - (b[0] - a[0]) * (c[1] - b[1])
    if k == 0:
        return 0
    elif k > 0:
        return 1
    return -1
    

def intersect(a1, b1, a2, b2):
    dir1 = direction(a1, a2, b1)
    dir2 = direction(a1, b2, b1)
    dir3 = direction(a2, a1, b2)
    dir4 = direction(a2, b1, b2)

    if dir1 != dir2 and dir3 != dir4:
        return True
    
    return (dir1 == 0 and on_line(a1, a2, b1)) or (dir2 == 0 and on_line(a1, b2, b1)) or (dir3 == 0 and on_line(a2, a1, b2)) or (dir4 == 0 and on_line(a2, b1, b2))

def inside_polygon(polygon):
    intr = 0
    i = 0
    while True:
        side1 = polygon[i]
        side2 = polygon[(i + 1) % len(polygon)]
        if intersect(side1, side2, (0, 0), (9999, 0)):
            if direction(side1, (0, 0), side2) == 0:
                return on_line(side1, (0, 0), side2)
            intr += 1
        i = (i + 1) % len(polygon)
        if i == 0:
            break
    return intr % 2 == 1

n = int(input())
france = []
for i in range(n):
    x, y = map(int, input().split())
    france.append((x, y))
subsets = list(chain.from_iterable(combinations(france, i) for i in range(1, len(france) + 1)))
count = 0
for subset in subsets:
    if len(subset) == 1:
        if subset[0] == (0, 0):
            count += 1
    elif len(subset) == 2:
        if direction(subset[0], (0, 0), subset[1]) == 0 and on_line(subset[0], (0, 0), subset[1]):
            count += 1
    else:
        pol = list(subset)
        if len(pol) > 3:
            pol = sort_points(pol)
        if inside_polygon(pol):
            count += 1

print(count % (pow(10, 9) + 7))