#include <bits/stdc++.h>

#define MAXN 10005

using namespace std;

struct point {
    long x;
    long y;
};

int orientation(struct point p1, struct point p2, struct point p3) {
    return (p1.x - p3.x) * (p2.y - p3.y) - (p2.x - p3.x) * (p1.y - p3.y);
}

int sign(int x) {
    if(x < 0)
        return -1;
    if(x > 0)
        return 1;
    return 0;
}

bool messiOnLine(struct point p1, struct point p2) {
    return((sign(p1.x) != sign(p2.x)) || (sign(p1.y) != sign(p2.y)));
}

bool messiInTriangle(struct point v1, struct point v2, struct point v3) {
    struct point messi;
    messi.x = 0;
    messi.y = 0;

    int d1 = orientation(messi, v1, v2);
    int d2 = orientation(messi, v2, v3);
    int d3 = orientation(messi, v3, v1);

    if(d1 == 0 && d2 == 0 && d3 == 0)
        return messiOnLine(v1, v2) || messiOnLine(v2, v3) || messiOnLine(v3, v1);
    if(d1 == 0 && d2 == 0)
        return messiOnLine(v1, v2) || messiOnLine(v2, v3);
    if(d1 == 0 && d3 == 0)
        return messiOnLine(v1, v2) || messiOnLine(v3, v1);
    if(d2 == 0 && d3 == 0)
        return messiOnLine(v2, v3) || messiOnLine(v3, v1);
    if(d1 == 0)
        return messiOnLine(v1, v2);
    if(d2 == 0)
        return messiOnLine(v2, v3);
    if(d3 == 0)
        return messiOnLine(v3, v1);

    return !(((d1 < 0) || (d2 < 0) || (d3 < 0)) && ((d1 > 0) || (d2 > 0) || (d3 > 0)));
}

bool foo(vector<struct point> & a) {
    int n = a.size();
    if(n < 3)
        return false;

    for(int i = 0; i < n - 2; i++)
        for(int j = i + 1; j < n - 1; j++)
            for(int k = j + 1; k < n; k++)
                if(messiInTriangle(a[i], a[j], a[k]))
                    return true;

    return false;
}

long long allPossibleSubset(vector<int> & s, vector<struct point> & a)
{
    int n = s.size();
    int count = pow(2, n);

    long long r = 0;

    vector<struct point> subset;
    for (int i = 0; i < count; i++) {
        subset.clear();
        for (int j = 0; j < n; j++) {
            if ((i & (1 << j)) != 0)
                subset.push_back(a[s[j]]);
        }
        if(foo(subset))
            r++;
    }
    return r % 1000000007;
}

int main()
{
    int n;
    cin >> n;

    vector<struct point> a;
    vector<int> s;
    for(int i = 0; i < n; i++) {
        struct point p;
        cin >> p.x >> p.y;
        a.push_back(p);
        s.push_back(i);
    }

    long long r = allPossibleSubset(s,a);
    cout << r << endl;

    return 0;
}