#include <bits/stdc++.h>

using namespace std;

bool cmp(pair<long long int, long long int>& a,
         pair<long long int, long long int>& b)
{

    if (a.first == b.first)
        return a.second < b.second;
    return a.first < b.first;
}

long long int cw(pair<long long int, long long int>& a,
       pair<long long int, long long int>& b,
       pair<long long int, long long int>& c)
{

    long long int p = a.first * (b.second - c.second)
            + b.first * (c.second - a.second)
            + c.first * (a.second - b.second);

    return p < 0ll;
}

long long int ccw(pair<long long int, long long int>& a,
        pair<long long int, long long int>& b,
        pair<long long int, long long int>& c)
{

    long long int p = a.first * (b.second - c.second)
            + b.first * (c.second - a.second)
            + c.first * (a.second - b.second);

    return p > 0ll;
}

vector<pair<long long int, long long int> > convexHull(
    vector<pair<long long int, long long int> >& v)
{
    sort(v.begin(),
         v.end(), cmp);

    long long int n = v.size();
    if (n <= 3)
        return v;

    pair<long long int, long long int> p1 = v[0];
    pair<long long int, long long int> p2 = v[n - 1];

    vector<pair<long long int, long long int> > up, down;

    up.push_back(p1);
    down.push_back(p1);

    for (long long int i = 1; i < n; i++) {

        if (i == n - 1 || !ccw(p1, v[i], p2)) {

            while (up.size() > 1
                   && ccw(up[up.size() - 2],
                          up[up.size() - 1],
                          v[i])) {


                up.pop_back();
            }

            up.push_back(v[i]);
        }

        if (i == n - 1 || !cw(p1, v[i], p2)) {

            while (down.size() > 1
                   && cw(down[down.size() - 2],
                         down[down.size() - 1],
                         v[i])) {

                down.pop_back();
            }
            down.push_back(v[i]);
        }
    }

    for (long long int i = down.size() - 2;
         i > 0; i--)
        up.push_back(down[i]);

    up.resize(unique(up.begin(),
                     up.end())
              - up.begin());

    return up;
}

bool isInside(vector<pair<long long int, long long int> > points,
              pair<long long int, long long int> query)
{
    points.push_back(query);
    points = convexHull(points);
    for (auto x : points)
    {
        if (x == query)
            return false;
    }
    return true;
}

void subsetsUtil(vector<pair<long long int, long long int>>& A, vector<vector<pair<long long int, long long int>> >& res,
                 vector<pair<long long int, long long int>>& subset, long long int index)
{
    res.push_back(subset);
    for (long long int i = index; i < A.size(); i++) {

        subset.push_back(A[i]);

        subsetsUtil(A, res, subset, i + 1);

        subset.pop_back();
    }

    return;
}

vector<vector<pair<long long int, long long int>>> subsets(vector<pair<long long int, long long int>>& A)
{
    vector<pair<long long int, long long int>> subset;
    vector<vector<pair<long long int, long long int>> > res;

    long long int index = 0LL;
    subsetsUtil(A, res, subset, index);

    return res;
}

int main()
{
    int n;
    vector<pair<long long int, long long int>> points;
    long long int sol = 0LL;
    cin >> n;
    for(int i = 1; i <= n; i++)
    {
        long long int p, q;
        cin >> p >> q;
        points.push_back(make_pair(p, q));
    }

    pair<long long int, long long int> query = { 0LL, 0LL };
    vector<vector<pair<long long int, long long int>>> subset = subsets(points);
    for(int i = 0; i < subset.size(); i++)
    {
        if (isInside(subset[i], query))
        {
            sol++;
        }
    }
    cout << sol % 1000000007LL << endl;

    return 0;
}