#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>

using namespace std;

const int INF = 1e9;

int n, m;
int a, b; // blocked point
vector<vector<int>> matrix;
vector<vector<int>> dist;

int dx[2] = {0, 1};
int dy[2] = {1, 0};

struct Node {
    int x, y, w;
    Node(int x, int y, int w) : x(x), y(y), w(w) {}
};

bool isValid(int x, int y) {
    if (x < 0 || x >= n || y < 0 || y >= m || (x == a && y == b)) {
        return false;
    }
    return true;
}

void bfs() {
    queue<Node> q;
    q.push(Node(0, 0, matrix[0][0]));
    dist[0][0] = matrix[0][0];

    while (!q.empty()) {
        Node curr = q.front();
        q.pop();

        if (curr.x == n-1 && curr.y == m-1) {
            break;
        }

        for (int i = 0; i < 2; i++) {
            int x = curr.x + dx[i];
            int y = curr.y + dy[i];
            if (isValid(x, y)) {
                int w = curr.w + matrix[x][y];
                if (w < dist[x][y]) {
                    dist[x][y] = w;
                    q.push(Node(x, y, w));
                }
            }
        }
    }
}

int main() {
    cin >> n >> m;
    cin >> a >> b;
    matrix.resize(n, vector<int>(m));
    dist.resize(n, vector<int>(m, INF));

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            cin >> matrix[i][j];
        }
    }

    bfs();

    cout << dist[n-1][m-1] << endl;

    return 0;
}