#include <iostream>
#include <algorithm>

using namespace std;

const int N = 105;

int t; // broj test primjera
int n, m; // dimenzije matrice predvidanja
int l[N][N]; // Lazareva predvidanja
int u[N][N]; // Ugleshin predvidanja
int mPredictions[N][N]; // Momirin predvidanja
int scores[N][N][2]; // matrica golova
int correctPredictions[2]; // broj tocno predvidenih utakmica po junaku

// Funkcija za provjeru da li su Momirin predvidanja ispravn
bool checkPredictions() {
  // Inicijalizirajte matricu golova na nulu
  for (int i = 0; i < n; i++) {
    for (int j = 0; j < m; j++) {
      scores[i][j][0] = scores[i][j][1] = 0;
    }
  }

  // Uvecajte broj golova
  for (int i = 0; i < n * m; i++) {
    int row = i / m; // red u matrici predvidanja
    int col = i % m; // stupac u matrici predvidanja
    scores[row][col][0] += l[row][col];
    scores[row][col][1] += u[row][col];
    scores[row][col][0] += mPredictions[row][col];
    scores[row][col][1] -= mPredictions[row][col];
  }

  // Provjerite da li su Momirin predvidanja ispravna
  for (int i = 0; i < n; i++) {
    for (int j = 0; j < m; j++) {
      if (scores[i][j][0] > scores[i][j][1]) {
        return false;
      }
    }
  }
  return true;
}

int main() {
  cin >> t;
  while (t--) {
    // Ucitajte dimenzije matrice i matrice predvidanja
    cin >> n >> m;
    for (int i = 0; i < n; i++) {
      for (int j = 0; j < m; j++) {
        cin >> l[i][j];
      }
    }
    for (int i = 0; i < n; i++) {
      for (int j = 0; j < m; j++) {
        cin >> u[i][j];
      }
    }

    // Generirajte Momirin predvidanja
    for (int i = 0; i < n; i++) {
      for (int j = 0; j < m; j++) {
        mPredictions[i][j] = l[i][j] - u[i][j];
      }
    }

    if (!checkPredictions()) {
      cout << "NE" << endl;
      continue;
    }

cout << "DA" << endl;
for (int i = 0; i < n; i++) {
  for (int j = 0; j < m; j++) {
    cout << mPredictions[i][j] << " ";
  }
  cout << endl;
}
  }
    }