#include <iostream>
#include <algorithm>
#include <climits>  // for INT_MAX

using namespace std;

const int MAXN = 100;

// costs[i][j] is the cost of moving from (0, 0) to (i, j)


// dp[i][j] is the minimum cost of moving from (0, 0) to (i, j)


int funkcija(int costs[MAXN][MAXN],int m,int n,int x,int y){
    costs[x][y] = INT_MAX-1000;
    int dp[MAXN][MAXN];
    // Initialize the first element of dp
    dp[1][1] = costs[1][1];
    
    // Initialize the first row of dp
    for (int j = 2; j <= m; j++)
    {
        dp[1][j] = dp[1][j - 1] + costs[1][j];
    }
    
    // Initialize the first column of dp
    for (int i = 2; i <= n; i++)
    {
        dp[i][1] = dp[i - 1][1] + costs[i][1];
    }

    // Fill in the rest of the dp array
    for (int i = 2; i <= n; i++)
    {
        for (int j = 2; j <= m; j++)
        {
            dp[i][j] = min(dp[i - 1][j], dp[i][j - 1]) + costs[i][j];
        }
    }
    return dp[n][m];
}
int main()
{
    // M x N matrix
    int M,N,x,y;cin>>N>>M;
    int Q;
    int A[MAXN][MAXN];
    // Fill in the costs array
    for (int i = 1; i <= N; i++)
    {
        for (int j = 1; j <= M; j++)
        {
            cin>>A[i][j];
        }
    }
    cin>>Q;
    
    // Set the blocked field to a very high cost
    

    // The minimum cost is now stored in dp[M - 1][N - 1]
    for(int i=0; i<Q;i++){
        cin>>x>>y;
        int tmp= A[x][y];
        cout<<funkcija(A,M,N,x,y);
        A[x][y]= tmp;
    }
    

    return 0;
}