#ubacujemo bilbiotke
from heapq import heappop, heappush
#definisemo dijkstra algoritam kao funkciju
def dijkstra(tezine, pocetak, kraj):
    #pravimo dictionary da drzi daljine izmdeju pocetka i svih ostalih nod-ova
    daljine = {pocetak: 0}

    #pravimo najmanji heap da drzi sve nod-ove koje treba da posetimo
    heap = [(0, pocetak)]

    #pravimo set da cuva posecene nodo-ve
    posecene = set()

    #dok ima nod-ova u heap-u
    while heap:
        # izbacujemo node sa najmanjom daljinom od heap-a
        daljina, node = heappop(heap)

        #ako smo posetili node preskacemo ga
        if node in posecene:
            continue

        #oznacavamo node kao posecen
        posecene.add(node)

        #ako je trenutni node krajnji node vracamo daljinu/tezinu
        if node == kraj:
            return daljina

        #Prolazimo kroz sve komsije od trenutnog nod-a
        for i, j in komsije(node):
            #Ako komsija ne postoji u matrici preskacemo
            if not (0 <= i < len(tezine) and 0 <= j < len(tezine[0])):
                continue
            if tezine[i][j] == 0:
                continue

            #racunamo daljinu/tezinu do komsije
            daljina_do_neighbor = daljina + tezine[i][j]

            #Ako je nova daljina/tezina manja od stare menjamo
            if daljina_do_neighbor < daljine.get((i, j), float('inf')):
                daljine[(i, j)] = daljina_do_neighbor
                heappush(heap, (daljina_do_neighbor, (i, j)))

def komsije(node):
    #vracamo koordinate komsije
    i, j = node
    return [(i + x, j + y) for x, y in [(0, 1), (0, -1), (1, 0), (-1, 0)]]
def testirajSlucaj(slucaj):
    #testiramo svaki slucaj
    #stavljamo da je i, j jednako koordinatama trenutnog slucaja
    i, j = slucaj[0] - 1, slucaj[1] - 1
    indx = slucajevi.index(slucaj)
    #ako nije prvi slucaj smanjujemo prosli slucaj za 1000000000 odnosno 10^9, ogranicenje iz zadatka, neprakticno ali radi
    if indx > 0:
        tezine[slucajevi[indx - 1][0] - 1][slucajevi[indx - 1][1] - 1] -= 1000000000
    #povecavamo tezinu trenutnog slucaja za 10^9
    tezine[i][j] += 1000000000
    #pozivamo dijkstra algoritam
    tezina = dijkstra(tezine, pocetak, kraj)
    #dodajemo tezinu hotela na tezinu iz algoritma
    print(tezina + tezine[0][0])

#ulaz i osnovne varijable iz zadatka
n, m = map(int, input().split())
navijaci = 0
slucajevi = []
tezine = []
pocetak = (0, 0)
kraj = (n-1, m-1)
for i in range(n):
    #unosimo svaki red
    red = list(map(int, input().split()))
    tezine.append(red)
q = int(input())
for j in range(q):
    slucajevi.append(list(map(int, input().split())))

#testiramo svaki slucaj
for slucaj in slucajevi:
    testirajSlucaj(slucaj)